/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.ast.factories.KiePMMLSimplePredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLSimplePredicateASTFactoryTest {
    @Test
    public void declareRuleFromSimplePredicateSurrogateFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        SimplePredicate simplePredicate = this.getSimplePredicate("outlook", "VALUE", SimplePredicate.Operator.LESS_THAN, fieldTypeMap);
        String currentRule = "_will play_will play";
        String agendaActivationGroup = "_will play_will play Group";
        String result = "RESULT";
        String parentPath = "parentPath";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simplePredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimplePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimplePredicateSurrogate(agendaActivationGroup, (Object)result, true);
        Assert.assertEquals((long)2L, (long)rules.size());
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        String baseExpectedRule = String.format("%s_surrogate_%s", currentRule, ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get(simplePredicate.getField().getValue())).getGeneratedType());
        String expectedRule = baseExpectedRule + "_TRUE";
        Assert.assertEquals((Object)expectedRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)"DONE", (Object)retrieved.getStatusToSet());
        Assert.assertNull((Object)retrieved.getStatusConstraint());
        Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getAgendaGroup());
        Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getActivationGroup());
        Assert.assertNull((Object)retrieved.getIfBreakField());
        Assert.assertNull((Object)retrieved.getIfBreakOperator());
        Assert.assertNull((Object)retrieved.getIfBreakValue());
        Assert.assertNull((Object)retrieved.getNotConstraints());
        Assertions.assertThat((List)retrieved.getAndConstraints()).isNotNull();
        Assert.assertEquals((long)1L, (long)retrieved.getAndConstraints().size());
        KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getAndConstraints().get(0);
        Assert.assertEquals((Object)"OUTLOOK", (Object)kiePMMLFieldOperatorValue.getName());
        Assert.assertEquals((Object)BOOLEAN_OPERATOR.SURROGATE, (Object)kiePMMLFieldOperatorValue.getOperator());
        Assert.assertEquals((Object)"value < \"VALUE\"", (Object)kiePMMLFieldOperatorValue.getConstraintsAsString());
        Assert.assertEquals((Object)result, (Object)retrieved.getResult());
        Assert.assertEquals((Object)ResultCode.OK, (Object)retrieved.getResultCode());
        retrieved = (KiePMMLDroolsRule)rules.get(1);
        Assertions.assertThat((Object)retrieved).isNotNull();
        expectedRule = baseExpectedRule + "_FALSE";
        Assert.assertEquals((Object)expectedRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)parentPath, (Object)retrieved.getStatusToSet());
        Assert.assertNull((Object)retrieved.getStatusConstraint());
        Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getAgendaGroup());
        Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getActivationGroup());
        Assert.assertNull((Object)retrieved.getIfBreakField());
        Assert.assertNull((Object)retrieved.getIfBreakOperator());
        Assert.assertNull((Object)retrieved.getIfBreakValue());
        Assert.assertNull((Object)retrieved.getAndConstraints());
        Assertions.assertThat((List)retrieved.getNotConstraints()).isNotNull();
        Assert.assertEquals((long)1L, (long)retrieved.getNotConstraints().size());
        kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getNotConstraints().get(0);
        Assert.assertEquals((Object)"OUTLOOK", (Object)kiePMMLFieldOperatorValue.getName());
        Assert.assertEquals((Object)BOOLEAN_OPERATOR.SURROGATE, (Object)kiePMMLFieldOperatorValue.getOperator());
        Assert.assertEquals((Object)"value < \"VALUE\"", (Object)kiePMMLFieldOperatorValue.getConstraintsAsString());
        Assert.assertNull((Object)retrieved.getResult());
        Assert.assertNull((Object)retrieved.getResultCode());
    }

    @Test
    public void declareRuleFromSimplePredicateSurrogateNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        SimplePredicate simplePredicate = this.getSimplePredicate("outlook", "VALUE", SimplePredicate.Operator.LESS_THAN, fieldTypeMap);
        String currentRule = "_will play_will play";
        String agendaActivationGroup = "_will play_will play Group";
        String result = "RESULT";
        String parentPath = "parentPath";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simplePredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimplePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimplePredicateSurrogate(agendaActivationGroup, (Object)result, false);
        Assert.assertEquals((long)2L, (long)rules.size());
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        String baseExpectedRule = String.format("%s_surrogate_%s", currentRule, ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get(simplePredicate.getField().getValue())).getGeneratedType());
        String expectedRule = baseExpectedRule + "_TRUE";
        Assert.assertEquals((Object)expectedRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getStatusToSet());
        Assert.assertNull((Object)retrieved.getStatusConstraint());
        Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getAgendaGroup());
        Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getActivationGroup());
        Assert.assertNull((Object)retrieved.getIfBreakField());
        Assert.assertNull((Object)retrieved.getIfBreakOperator());
        Assert.assertNull((Object)retrieved.getIfBreakValue());
        Assertions.assertThat((List)retrieved.getAndConstraints()).isNotNull();
        Assert.assertEquals((long)1L, (long)retrieved.getAndConstraints().size());
        KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getAndConstraints().get(0);
        Assert.assertEquals((Object)"OUTLOOK", (Object)kiePMMLFieldOperatorValue.getName());
        Assert.assertEquals((Object)BOOLEAN_OPERATOR.SURROGATE, (Object)kiePMMLFieldOperatorValue.getOperator());
        Assert.assertEquals((Object)"value < \"VALUE\"", (Object)kiePMMLFieldOperatorValue.getConstraintsAsString());
        Assert.assertNull((Object)retrieved.getResult());
        Assert.assertNull((Object)retrieved.getResultCode());
        retrieved = (KiePMMLDroolsRule)rules.get(1);
        Assertions.assertThat((Object)retrieved).isNotNull();
        expectedRule = baseExpectedRule + "_FALSE";
        Assert.assertEquals((Object)expectedRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)parentPath, (Object)retrieved.getStatusToSet());
        Assert.assertNull((Object)retrieved.getStatusConstraint());
        Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getAgendaGroup());
        Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getActivationGroup());
        Assert.assertNull((Object)retrieved.getIfBreakField());
        Assert.assertNull((Object)retrieved.getIfBreakOperator());
        Assert.assertNull((Object)retrieved.getIfBreakValue());
        Assert.assertNull((Object)retrieved.getAndConstraints());
        Assertions.assertThat((List)retrieved.getNotConstraints()).isNotNull();
        Assert.assertEquals((long)1L, (long)retrieved.getNotConstraints().size());
        kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getNotConstraints().get(0);
        Assert.assertEquals((Object)"OUTLOOK", (Object)kiePMMLFieldOperatorValue.getName());
        Assert.assertEquals((Object)BOOLEAN_OPERATOR.SURROGATE, (Object)kiePMMLFieldOperatorValue.getOperator());
        Assert.assertEquals((Object)"value < \"VALUE\"", (Object)kiePMMLFieldOperatorValue.getConstraintsAsString());
        Assert.assertNull((Object)retrieved.getResult());
        Assert.assertNull((Object)retrieved.getResultCode());
    }

    @Test
    public void declareRuleFromSimplePredicateFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        SimplePredicate simplePredicate = this.getSimplePredicate("outlook", "VALUE", SimplePredicate.Operator.LESS_THAN, fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("outlook")).getGeneratedType();
        String result = "RESULT";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simplePredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimplePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimplePredicate((Object)result, true);
        Assert.assertEquals((long)1L, (long)rules.size());
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)"DONE", (Object)retrieved.getStatusToSet());
        Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
        Assert.assertEquals((Object)ResultCode.OK, (Object)retrieved.getResultCode());
        Assert.assertEquals((Object)result, (Object)retrieved.getResult());
        List andConstraints = retrieved.getAndConstraints();
        Assertions.assertThat((List)andConstraints).isNotNull();
        Assert.assertEquals((long)1L, (long)andConstraints.size());
        KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getAndConstraints().get(0);
        Assert.assertEquals((Object)declaredType, (Object)kiePMMLFieldOperatorValue.getName());
        Assert.assertEquals((Object)BOOLEAN_OPERATOR.AND, (Object)kiePMMLFieldOperatorValue.getOperator());
        String expectedValue = "value < \"" + simplePredicate.getValue() + "\"";
        Assert.assertEquals((Object)expectedValue, (Object)kiePMMLFieldOperatorValue.getConstraintsAsString());
    }

    @Test
    public void declareIntermediateRuleFromSimplePredicateNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        SimplePredicate simplePredicate = this.getSimplePredicate("outlook", "VALUE", SimplePredicate.Operator.LESS_THAN, fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("outlook")).getGeneratedType();
        String result = "RESULT";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simplePredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimplePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimplePredicate((Object)result, false);
        Assert.assertEquals((long)1L, (long)rules.size());
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getName());
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getStatusToSet());
        Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
        Assert.assertEquals((Object)currentRule, (Object)retrieved.getStatusToSet());
        List andConstraints = retrieved.getAndConstraints();
        Assertions.assertThat((List)andConstraints).isNotNull();
        Assert.assertEquals((long)1L, (long)andConstraints.size());
        KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getAndConstraints().get(0);
        Assert.assertEquals((Object)declaredType, (Object)kiePMMLFieldOperatorValue.getName());
        Assert.assertEquals((Object)BOOLEAN_OPERATOR.AND, (Object)kiePMMLFieldOperatorValue.getOperator());
        String expectedValue = "value < \"" + simplePredicate.getValue() + "\"";
        Assert.assertEquals((Object)expectedValue, (Object)kiePMMLFieldOperatorValue.getConstraintsAsString());
    }

    private SimplePredicate getSimplePredicate(String predicateName, Object value, SimplePredicate.Operator operator, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        fieldTypeMap.put(predicateName, new KiePMMLOriginalTypeGeneratedType(DataType.STRING.value(), KiePMMLModelUtils.getSanitizedClassName((String)predicateName.toUpperCase())));
        return PMMLModelTestUtils.getSimplePredicate((String)predicateName, (Object)value, (SimplePredicate.Operator)operator);
    }
}

