/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.testutils.TestUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.tree.compiler.factories.KiePMMLTreeModelFactory;
import org.kie.pmml.models.drools.tree.model.KiePMMLTreeModel;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLTreeModelFactoryTest {
    private static final String SOURCE_1 = "TreeSample.pmml";
    private static final String TARGET_FIELD = "whatIdo";
    private static final String PACKAGE_NAME = "packagename";
    private static PMML pmml;
    private static TreeModel treeModel;
    private static ClassOrInterfaceDeclaration classOrInterfaceDeclaration;

    @BeforeClass
    public static void setUp() throws Exception {
        pmml = TestUtils.loadFromFile((String)SOURCE_1);
        Assert.assertNotNull((Object)pmml);
        Assert.assertEquals((long)1L, (long)pmml.getModels().size());
        Assert.assertTrue((boolean)(pmml.getModels().get(0) instanceof TreeModel));
        treeModel = (TreeModel)pmml.getModels().get(0);
        CompilationUnit templateCU = JavaParserUtils.getFromFileName((String)"KiePMMLTreeModelTemplate.tmpl");
        classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)templateCU.getClassByName("KiePMMLTreeModelTemplate").get();
    }

    @Test
    public void getKiePMMLTreeModel() throws InstantiationException, IllegalAccessException {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (LocalTransformations)treeModel.getLocalTransformations());
        KiePMMLTreeModel retrieved = KiePMMLTreeModelFactory.getKiePMMLTreeModel((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (TreeModel)treeModel, (Map)fieldTypeMap, (String)PACKAGE_NAME, (HasClassLoader)new HasClassLoaderMock());
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)treeModel.getModelName(), (Object)retrieved.getName());
        Assert.assertEquals((Object)TARGET_FIELD, (Object)retrieved.getTargetField());
    }

    @Test
    public void getKiePMMLScorecardModelSourcesMap() {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (LocalTransformations)treeModel.getLocalTransformations());
        Map retrieved = KiePMMLTreeModelFactory.getKiePMMLTreeModelSourcesMap((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (TreeModel)treeModel, (Map)fieldTypeMap, (String)PACKAGE_NAME);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
    }

    @Test
    public void getKiePMMLDroolsAST() {
        DataDictionary dataDictionary = pmml.getDataDictionary();
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (LocalTransformations)treeModel.getLocalTransformations());
        KiePMMLDroolsAST retrieved = KiePMMLTreeModelFactory.getKiePMMLDroolsAST((DataDictionary)dataDictionary, (TreeModel)treeModel, (Map)fieldTypeMap, Collections.emptyList());
        Assert.assertNotNull((Object)retrieved);
        List dataFields = dataDictionary.getDataFields();
        Assert.assertEquals((long)dataFields.size(), (long)fieldTypeMap.size());
        dataFields.forEach(dataField -> Assert.assertTrue((boolean)fieldTypeMap.containsKey(dataField.getName().getValue())));
    }

    @Test
    public void setConstructor() {
        String targetField = TARGET_FIELD;
        ClassOrInterfaceDeclaration modelTemplate = classOrInterfaceDeclaration.clone();
        KiePMMLTreeModelFactory.setConstructor((TreeModel)treeModel, (DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (ClassOrInterfaceDeclaration)modelTemplate);
        HashMap<Integer, NameExpr> superInvocationExpressionsMap = new HashMap<Integer, NameExpr>();
        superInvocationExpressionsMap.put(0, new NameExpr(String.format("\"%s\"", treeModel.getModelName())));
        superInvocationExpressionsMap.put(2, new NameExpr(String.format("\"%s\"", treeModel.getAlgorithmName())));
        MINING_FUNCTION miningFunction = MINING_FUNCTION.byName((String)treeModel.getMiningFunction().value());
        PMML_MODEL pmmlModel = PMML_MODEL.byName((String)treeModel.getClass().getSimpleName());
        HashMap<String, Object> assignExpressionMap = new HashMap<String, Object>();
        assignExpressionMap.put("targetField", new StringLiteralExpr(TARGET_FIELD));
        assignExpressionMap.put("miningFunction", new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
        assignExpressionMap.put("pmmlMODEL", new NameExpr(pmmlModel.getClass().getName() + "." + pmmlModel.name()));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().get();
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor((ConstructorDeclaration)constructorDeclaration, (String)KiePMMLModelUtils.getSanitizedClassName((String)treeModel.getModelName()), superInvocationExpressionsMap, assignExpressionMap));
    }
}

