/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.evaluator;

import java.util.HashMap;
import java.util.Map;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.tree.TreeModel;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.modelcompiler.ExecutableModelProject;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.KieDescr;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.internal.utils.KieHelper;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.compiler.testutils.TestUtils;
import org.kie.pmml.evaluator.core.PMMLContextImpl;
import org.kie.pmml.evaluator.core.utils.PMMLRequestDataBuilder;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;
import org.kie.pmml.models.drools.tree.compiler.executor.TreeModelImplementationProvider;
import org.kie.pmml.models.drools.tree.evaluator.PMMLTreeModelEvaluator;
import org.kie.pmml.models.drools.tree.evaluator.implementations.HasKnowledgeBuilderMock;
import org.kie.pmml.models.drools.tree.model.KiePMMLTreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLTreeModelEvaluatorTest {
    private static final String SOURCE_1 = "TreeSample.pmml";
    private static final String PACKAGE_NAME = "PACKAGE_NAME";
    private static final Logger logger = LoggerFactory.getLogger(PMMLTreeModelEvaluatorTest.class);
    private static final String modelName = "golfing";
    private static final ReleaseId RELEASE_ID = new ReleaseIdImpl("org", "test", "1.0.0");
    private static final TreeModelImplementationProvider provider = new TreeModelImplementationProvider();
    private static KiePMMLTreeModel kiePMMLModel;
    private static PMMLTreeModelEvaluator evaluator;
    private static KieBase kieBase;
    private final String SCORE = "SCORE";
    private final String WILL_PLAY = "will play";
    private final String NO_PLAY = "no play";
    private final String MAY_PLAY = "may play";
    private final String WHO_PLAY = "who play";
    private final String HUMIDITY = "humidity";
    private final String TEMPERATURE = "temperature";
    private final String OUTLOOK = "outlook";
    private final String SUNNY = "sunny";
    private final String WINDY = "windy";
    private final String OVERCAST = "overcast";
    private final String RAIN = "rain";
    private final String TARGET_FIELD = "whatIdo";

    @BeforeClass
    public static void setUp() throws Exception {
        evaluator = new PMMLTreeModelEvaluator();
        PMML pmml = TestUtils.loadFromFile((String)SOURCE_1);
        Assert.assertNotNull((Object)pmml);
        Assert.assertEquals((long)1L, (long)pmml.getModels().size());
        Assert.assertTrue((boolean)(pmml.getModels().get(0) instanceof TreeModel));
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        kiePMMLModel = (KiePMMLTreeModel)provider.getKiePMMLModel(PACKAGE_NAME, pmml.getDataDictionary(), pmml.getTransformationDictionary(), (Model)((TreeModel)pmml.getModels().get(0)), (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        kieBase = new KieHelper().addContent((KieDescr)knowledgeBuilder.getPackageDescrs(kiePMMLModel.getKModulePackageName()).get(0)).setReleaseId(RELEASE_ID).build(ExecutableModelProject.class, new KieBaseOption[0]);
        Assert.assertNotNull((Object)kieBase);
    }

    @Test
    public void getPMMLModelType() {
        Assert.assertEquals((Object)PMML_MODEL.TREE_MODEL, (Object)evaluator.getPMMLModelType());
    }

    @Test
    public void evaluateNull() throws Exception {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("outlook", "sunny");
        this.commonEvaluate(modelName, inputData, null);
        inputData.clear();
        inputData.put("outlook", "sunny");
        inputData.put("temperature", 65.0);
        this.commonEvaluate(modelName, inputData, null);
        inputData.clear();
        inputData.put("outlook", "overcast");
        this.commonEvaluate(modelName, inputData, null);
        inputData.clear();
        inputData.put("outlook", "rain");
        this.commonEvaluate(modelName, inputData, null);
        inputData.clear();
        inputData.put("outlook", "overcast");
        inputData.put("temperature", 80.0);
        this.commonEvaluate(modelName, inputData, null);
    }

    @Test
    public void evaluateWillPlay() throws Exception {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("outlook", "sunny");
        inputData.put("temperature", 65.0);
        inputData.put("humidity", 65.0);
        this.commonEvaluate(modelName, inputData, "will play");
    }

    @Test
    public void evaluateNoPlay() throws Exception {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("outlook", "sunny");
        inputData.put("temperature", 65.0);
        inputData.put("humidity", 95.0);
        this.commonEvaluate(modelName, inputData, "no play");
        inputData.clear();
        inputData.put("outlook", "sunny");
        inputData.put("humidity", 95.0);
        inputData.put("temperature", 95.0);
        this.commonEvaluate(modelName, inputData, "no play");
        inputData.clear();
        inputData.put("outlook", "sunny");
        inputData.put("temperature", 95.0);
        this.commonEvaluate(modelName, inputData, "no play");
        inputData.clear();
        inputData.put("outlook", "sunny");
        inputData.put("temperature", 45.0);
        this.commonEvaluate(modelName, inputData, "no play");
        inputData.clear();
        inputData.put("outlook", "rain");
        inputData.put("humidity", 45.0);
        this.commonEvaluate(modelName, inputData, "no play");
    }

    @Test
    public void evaluateMayPlay() throws Exception {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("outlook", "overcast");
        inputData.put("temperature", 70.0);
        inputData.put("humidity", 60.0);
        inputData.put("windy", "false");
        this.commonEvaluate(modelName, inputData, "may play");
    }

    @Test
    public void evaluateWhoPlay() throws Exception {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("temperature", 75.0);
        inputData.put("windy", "true");
        inputData.put("humidity", 75.0);
        this.commonEvaluate(modelName, inputData, "who play");
        inputData.clear();
        inputData.put("windy", "false");
        inputData.put("temperature", 65.0);
        inputData.put("humidity", 75.0);
        this.commonEvaluate(modelName, inputData, "who play");
    }

    private void commonEvaluate(String modelName, Map<String, Object> inputData, String expectedScore) {
        PMMLRequestData pmmlRequestData = this.getPMMLRequestData(modelName, inputData);
        PMMLContextImpl pmmlContext = new PMMLContextImpl(pmmlRequestData);
        this.commonEvaluate((PMMLContext)pmmlContext, expectedScore);
    }

    private void commonEvaluate(PMMLContext pmmlContext, String expectedScore) {
        PMML4Result retrieved = evaluator.evaluate(kieBase, (KiePMMLDroolsModel)kiePMMLModel, pmmlContext);
        Assert.assertNotNull((Object)retrieved);
        logger.trace(retrieved.toString());
        Assert.assertEquals((Object)"whatIdo", (Object)retrieved.getResultObjectName());
        Map resultVariables = retrieved.getResultVariables();
        Assert.assertNotNull((Object)resultVariables);
        if (expectedScore != null) {
            Assert.assertEquals((Object)ResultCode.OK.getName(), (Object)retrieved.getResultCode());
            Assert.assertFalse((boolean)resultVariables.isEmpty());
            Assert.assertTrue((boolean)resultVariables.containsKey("whatIdo"));
            Assert.assertEquals((Object)expectedScore, resultVariables.get("whatIdo"));
        } else {
            Assert.assertEquals((Object)ResultCode.FAIL.getName(), (Object)retrieved.getResultCode());
            Assert.assertFalse((boolean)resultVariables.containsKey("whatIdo"));
        }
    }

    private PMMLRequestData getPMMLRequestData(String modelName, Map<String, Object> parameters) {
        String correlationId = "CORRELATION_ID";
        PMMLRequestDataBuilder pmmlRequestDataBuilder = new PMMLRequestDataBuilder(correlationId, modelName);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            Object pValue = entry.getValue();
            Class<?> class1 = pValue.getClass();
            pmmlRequestDataBuilder.addParameter(entry.getKey(), pValue, class1);
        }
        return pmmlRequestDataBuilder.build();
    }
}

