/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class SampleMineTreeModelWithTransformationsTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "SampleMineTreeModelWithTransformations.pmml";
    private static final String MODEL_NAME = "SampleMineTreeModelWithTransformations";
    private static final String TARGET_FIELD = "decision";
    private static final String OUT_DER_TEMPERATURE = "out_der_temperature";
    private static final String OUT_DER_HUMIDITY = "out_der_humidity";
    private static final String OUT_DER_CONSTANT = "out_der_constant";
    private static final String CONSTANT = "constant";
    private static PMMLRuntime pmmlRuntime;
    private double temperature;
    private double humidity;
    private String expectedResult;

    public SampleMineTreeModelWithTransformationsTest(double temperature, double humidity, String expectedResult) {
        this.temperature = temperature;
        this.humidity = humidity;
        this.expectedResult = expectedResult;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = SampleMineTreeModelWithTransformationsTest.getPMMLRuntime((String)MODEL_NAME, (String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({30.0, 10.0, "sunglasses"}, {5.0, 70.0, "umbrella"}, {10.0, 15.0, "nothing"});
    }

    @Test
    public void testSetPredicateTree() {
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("temperature", this.temperature);
        inputData.put("humidity", this.humidity);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.expectedResult);
    }
}

