/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class SimpleSetPredicateTreeTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "SimpleSetPredicateTree.pmml";
    private static final String MODEL_NAME = "SimpleSetPredicateTreeModel";
    private static final String TARGET_FIELD = "Predicted_result";
    private static PMMLRuntime pmmlRuntime;
    private double input1;
    private double input2;
    private double input3;
    private String expectedResult;

    public void initSimpleSetPredicateTreeTest(double input1, double input2, double input3, String expectedResult) {
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.expectedResult = expectedResult;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = SimpleSetPredicateTreeTest.getPMMLRuntime((String)FILE_NAME);
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({0, 3, 0, "classA"}, {0, 8.5, 0, "classA"}, {-5, 0, 0, "classB"}, {0.5, 0, 0, "classB"}, {1, 0, 0, "classB"}, {10, 0, 0, "classB"}, {-10, 15, 15, "classC"});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testSetPredicateTree(double input1, double input2, double input3, String expectedResult) {
        this.initSimpleSetPredicateTreeTest(input1, input2, input3, expectedResult);
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("input1", input1);
        inputData.put("input2", input2);
        inputData.put("input3", input3);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)expectedResult);
    }
}

