/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.junit.Assert;
import org.junit.Before;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;
import org.xml.sax.SAXException;

public abstract class AbstractKiePMMLFactoryTest {
    protected static final String SOURCE_MIXED = "MiningModel_Mixed.pmml";
    protected static final String PACKAGE_NAME = "packagename";
    protected static DataDictionary DATA_DICTIONARY;
    protected static TransformationDictionary TRANSFORMATION_DICTIONARY;
    protected static MiningModel MINING_MODEL;
    protected static KnowledgeBuilderImpl KNOWLEDGE_BUILDER;

    protected static void innerSetup() throws JAXBException, SAXException, IOException {
        FileInputStream fis = FileUtils.getFileInputStream((String)SOURCE_MIXED);
        PMML pmml = KiePMMLUtil.load((InputStream)fis, (String)SOURCE_MIXED);
        Assert.assertNotNull((Object)pmml);
        DATA_DICTIONARY = pmml.getDataDictionary();
        Assert.assertNotNull((Object)DATA_DICTIONARY);
        TRANSFORMATION_DICTIONARY = pmml.getTransformationDictionary();
        Assert.assertTrue((boolean)(pmml.getModels().get(0) instanceof MiningModel));
        MINING_MODEL = (MiningModel)pmml.getModels().get(0);
        Assert.assertNotNull((Object)MINING_MODEL);
        AbstractKiePMMLFactoryTest.populateMissingIds(MINING_MODEL);
    }

    @Before
    public void init() {
        KNOWLEDGE_BUILDER = new KnowledgeBuilderImpl();
    }

    private static void populateMissingIds(MiningModel model) {
        List segments = model.getSegmentation().getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            Segment segment = (Segment)segments.get(i);
            if (segment.getId() != null && !segment.getId().isEmpty()) continue;
            String toSet = String.format("%sSegment%s", model.getModelName(), i);
            segment.setId(toSet);
            if (!(segment.getModel() instanceof MiningModel)) continue;
            AbstractKiePMMLFactoryTest.populateMissingIds((MiningModel)segment.getModel());
        }
    }
}

