/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.RandomStringUtils;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.mining.MiningModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.mining.compiler.HasKnowledgeBuilderMock;
import org.kie.pmml.models.mining.compiler.factories.AbstractKiePMMLFactoryTest;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLMiningModelFactory;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.xml.sax.SAXException;

public class KiePMMLMiningModelFactoryTest
extends AbstractKiePMMLFactoryTest {
    private static final String TEMPLATE_SOURCE = "KiePMMLMiningModelTemplate.tmpl";
    private static final String TEMPLATE_CLASS_NAME = "KiePMMLMiningModelTemplate";
    private static final String PACKAGE_NAME = "PACKAGE_NAME";
    private static CompilationUnit COMPILATION_UNIT;
    private static ClassOrInterfaceDeclaration MODEL_TEMPLATE;

    @BeforeClass
    public static void setup() throws IOException, JAXBException, SAXException {
        KiePMMLMiningModelFactoryTest.innerSetup();
        COMPILATION_UNIT = JavaParserUtils.getFromFileName((String)TEMPLATE_SOURCE);
        MODEL_TEMPLATE = (ClassOrInterfaceDeclaration)COMPILATION_UNIT.getClassByName(TEMPLATE_CLASS_NAME).get();
    }

    @Test
    public void getKiePMMLMiningModel() {
        KiePMMLMiningModel retrieved = KiePMMLMiningModelFactory.getKiePMMLMiningModel((DataDictionary)DATA_DICTIONARY, (TransformationDictionary)TRANSFORMATION_DICTIONARY, (MiningModel)MINING_MODEL, (String)PACKAGE_NAME, (HasClassLoader)new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER));
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)MINING_MODEL.getAlgorithmName(), (Object)retrieved.getAlgorithmName());
        Assert.assertEquals((Object)MINING_MODEL.isScorable(), (Object)retrieved.isScorable());
        String expectedTargetField = "categoricalResult";
        Assert.assertEquals((Object)"categoricalResult", (Object)retrieved.getTargetField());
    }

    @Test
    public void getKiePMMLMiningModelSourcesMap() {
        String packageName = "packagename";
        ArrayList nestedModels = new ArrayList();
        Map retrieved = KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMap((DataDictionary)DATA_DICTIONARY, (TransformationDictionary)TRANSFORMATION_DICTIONARY, (MiningModel)MINING_MODEL, (String)"packagename", (HasClassLoader)new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER), nestedModels);
        Assert.assertNotNull((Object)retrieved);
        int expectedNestedModels = MINING_MODEL.getSegmentation().getSegments().size();
        Assert.assertEquals((long)expectedNestedModels, (long)nestedModels.size());
    }

    @Test
    public void getKiePMMLMiningModelSourcesMapCompiled() {
        ArrayList nestedModels = new ArrayList();
        HasKnowledgeBuilderMock hasKnowledgeBuilderMock = new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER);
        String segmentationName = String.format("%s_Segmentation", MINING_MODEL.getModelName());
        List<String> expectedGeneratedClasses = MINING_MODEL.getSegmentation().getSegments().stream().map(segment -> {
            String modelName = segment.getModel().getModelName();
            String sanitizedPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)("PACKAGE_NAME." + segmentationName + "." + segment.getId() + "." + modelName));
            String sanitizedClassName = KiePMMLModelUtils.getSanitizedClassName((String)modelName);
            return String.format("%s.%s", sanitizedPackageName, sanitizedClassName);
        }).collect(Collectors.toList());
        expectedGeneratedClasses.forEach(expectedGeneratedClass -> {
            try {
                hasKnowledgeBuilderMock.getClassLoader().loadClass((String)expectedGeneratedClass);
                Assert.fail((String)("Expecting class not found: " + expectedGeneratedClass));
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof ClassNotFoundException));
            }
        });
        Map retrieved = KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMapCompiled((DataDictionary)DATA_DICTIONARY, (TransformationDictionary)TRANSFORMATION_DICTIONARY, (MiningModel)MINING_MODEL, (String)PACKAGE_NAME, (HasClassLoader)hasKnowledgeBuilderMock, nestedModels);
        Assert.assertNotNull((Object)retrieved);
        int expectedNestedModels = MINING_MODEL.getSegmentation().getSegments().size();
        Assert.assertEquals((long)expectedNestedModels, (long)nestedModels.size());
        expectedGeneratedClasses.forEach(expectedGeneratedClass -> {
            try {
                hasKnowledgeBuilderMock.getClassLoader().loadClass((String)expectedGeneratedClass);
            }
            catch (Exception e) {
                Assert.fail((String)("Expecting class to be loaded, but got: " + e.getClass().getName() + " -> " + e.getMessage()));
                e.printStackTrace();
            }
        });
    }

    @Test
    public void setConstructor() {
        MiningModel model = new MiningModel();
        model.setModelName(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        model.setMiningFunction(MiningFunction.CLASSIFICATION);
        PMML_MODEL pmmlModel = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        ClassOrInterfaceDeclaration modelTemplate = MODEL_TEMPLATE.clone();
        MINING_FUNCTION miningFunction = MINING_FUNCTION.byName((String)model.getMiningFunction().value());
        String segmentationClass = "SEGMENTATIONCLASS";
        KiePMMLMiningModelFactory.setConstructor((MiningModel)model, (DataDictionary)new DataDictionary(), (TransformationDictionary)new TransformationDictionary(), (ClassOrInterfaceDeclaration)modelTemplate, (String)segmentationClass);
        HashMap<Integer, NameExpr> superInvocationExpressionsMap = new HashMap<Integer, NameExpr>();
        superInvocationExpressionsMap.put(0, new NameExpr(String.format("\"%s\"", model.getModelName())));
        HashMap<String, Object> assignExpressionMap = new HashMap<String, Object>();
        assignExpressionMap.put("targetField", new NullLiteralExpr());
        assignExpressionMap.put("miningFunction", new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
        assignExpressionMap.put("pmmlMODEL", new NameExpr(pmmlModel.getClass().getName() + "." + pmmlModel.name()));
        ClassOrInterfaceType kiePMMLSegmentationClass = StaticJavaParser.parseClassOrInterfaceType((String)segmentationClass);
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentationClass);
        assignExpressionMap.put("segmentation", objectCreationExpr);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().get();
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor((ConstructorDeclaration)constructorDeclaration, (String)KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName()), superInvocationExpressionsMap, assignExpressionMap));
    }
}

