/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.mining.Segment;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.mining.compiler.HasKnowledgeBuilderMock;
import org.kie.pmml.models.mining.compiler.factories.AbstractKiePMMLFactoryTest;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLSegmentFactory;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegment;
import org.xml.sax.SAXException;

public class KiePMMLSegmentFactoryTest
extends AbstractKiePMMLFactoryTest {
    private static CompilationUnit COMPILATION_UNIT;
    private static ClassOrInterfaceDeclaration MODEL_TEMPLATE;

    @BeforeClass
    public static void setup() throws IOException, JAXBException, SAXException {
        KiePMMLSegmentFactoryTest.innerSetup();
        COMPILATION_UNIT = JavaParserUtils.getFromFileName((String)"KiePMMLSegmentTemplate.tmpl");
        MODEL_TEMPLATE = (ClassOrInterfaceDeclaration)COMPILATION_UNIT.getClassByName("KiePMMLSegmentTemplate").get();
    }

    @Test
    public void getSegments() {
        List segments = MINING_MODEL.getSegmentation().getSegments();
        List retrieved = KiePMMLSegmentFactory.getSegments((String)"packagename", (DataDictionary)DATA_DICTIONARY, (TransformationDictionary)TRANSFORMATION_DICTIONARY, (List)segments, (HasClassLoader)new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER));
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)segments.size(), (long)retrieved.size());
        for (int i = 0; i < segments.size(); ++i) {
            this.commonEvaluateSegment((KiePMMLSegment)retrieved.get(i), (Segment)segments.get(i));
        }
    }

    @Test
    public void getSegment() {
        Segment segment = (Segment)MINING_MODEL.getSegmentation().getSegments().get(0);
        KiePMMLSegment retrieved = KiePMMLSegmentFactory.getSegment((String)"packagename", (DataDictionary)DATA_DICTIONARY, (TransformationDictionary)TRANSFORMATION_DICTIONARY, (Segment)segment, (HasClassLoader)new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER));
        this.commonEvaluateSegment(retrieved, segment);
    }

    @Test
    public void getSegmentsSourcesMap() {
        List segments = MINING_MODEL.getSegmentation().getSegments();
        ArrayList<KiePMMLModel> nestedModels = new ArrayList<KiePMMLModel>();
        Map retrieved = KiePMMLSegmentFactory.getSegmentsSourcesMap((String)"packagename", (DataDictionary)DATA_DICTIONARY, (TransformationDictionary)TRANSFORMATION_DICTIONARY, (List)segments, (HasClassLoader)new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER), nestedModels);
        Assert.assertNotNull((Object)retrieved);
        this.commonEvaluateNestedModels(nestedModels);
        for (Segment segment : segments) {
            this.commonEvaluateMap(retrieved, segment);
        }
    }

    @Test
    public void getSegmentSourcesMap() {
        Segment segment = (Segment)MINING_MODEL.getSegmentation().getSegments().get(0);
        ArrayList<KiePMMLModel> nestedModels = new ArrayList<KiePMMLModel>();
        Map retrieved = KiePMMLSegmentFactory.getSegmentSourcesMap((String)"packagename", (DataDictionary)DATA_DICTIONARY, (TransformationDictionary)TRANSFORMATION_DICTIONARY, (Segment)segment, (HasClassLoader)new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER), nestedModels);
        this.commonEvaluateNestedModels(nestedModels);
        this.commonEvaluateMap(retrieved, segment);
    }

    @Test
    public void getSegmentSourcesMapCompiled() throws Exception {
        Segment segment = (Segment)MINING_MODEL.getSegmentation().getSegments().get(0);
        ArrayList<KiePMMLModel> nestedModels = new ArrayList<KiePMMLModel>();
        String modelName = segment.getModel().getModelName();
        String sanitizedPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)("packagename." + segment.getId() + "." + modelName));
        String sanitizedClassName = KiePMMLModelUtils.getSanitizedClassName((String)modelName);
        String expectedGeneratedClass = String.format("%s.%s", sanitizedPackageName, sanitizedClassName);
        HasKnowledgeBuilderMock hasKnowledgeBuilderMock = new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER);
        try {
            hasKnowledgeBuilderMock.getClassLoader().loadClass(expectedGeneratedClass);
            Assert.fail((String)("Expecting class not found: " + expectedGeneratedClass));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof ClassNotFoundException));
        }
        Map retrieved = KiePMMLSegmentFactory.getSegmentSourcesMapCompiled((String)"packagename", (DataDictionary)DATA_DICTIONARY, (TransformationDictionary)TRANSFORMATION_DICTIONARY, (Segment)segment, (HasClassLoader)hasKnowledgeBuilderMock, nestedModels);
        this.commonEvaluateNestedModels(nestedModels);
        this.commonEvaluateMap(retrieved, segment);
        hasKnowledgeBuilderMock.getClassLoader().loadClass(expectedGeneratedClass);
    }

    @Test
    public void getSegmentSourcesMapHasSourcesWithKiePMMLModelClass() {
        Segment segment = (Segment)MINING_MODEL.getSegmentation().getSegments().get(0);
        String regressionModelName = "CategoricalVariablesRegression";
        String kiePMMLModelClass = "packagename.CategoricalVariablesRegression";
        HashMap<String, String> sourcesMap = new HashMap<String, String>();
        sourcesMap.put("packagename.CategoricalVariablesRegression", String.format("public class %s {}", "CategoricalVariablesRegression"));
        Map retrieved = KiePMMLSegmentFactory.getSegmentSourcesMap((String)"packagename", (DataDictionary)DATA_DICTIONARY, (Segment)segment);
        this.commonEvaluateMap(retrieved, segment);
    }

    @Test
    public void setConstructor() {
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)MODEL_TEMPLATE.getDefaultConstructor().get();
        String segmentName = "SEGMENTNAME";
        String generatedClassName = "GENERATEDCLASSNAME";
        String predicateClassName = "PREDICATECLASSNAME";
        String kiePMMLModelClass = "KIEPMMLMODELCLASS";
        double weight = 12.22;
        KiePMMLSegmentFactory.setConstructor((String)segmentName, (String)generatedClassName, (ConstructorDeclaration)constructorDeclaration, (String)predicateClassName, (String)kiePMMLModelClass, (double)weight);
        HashMap<Integer, NameExpr> superInvocationExpressionsMap = new HashMap<Integer, NameExpr>();
        superInvocationExpressionsMap.put(0, new NameExpr(String.format("\"%s\"", segmentName)));
        ClassOrInterfaceType classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)predicateClassName);
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(classOrInterfaceType);
        superInvocationExpressionsMap.put(2, new NameExpr(objectCreationExpr.toString()));
        classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)kiePMMLModelClass);
        objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(classOrInterfaceType);
        superInvocationExpressionsMap.put(3, new NameExpr(objectCreationExpr.toString()));
        HashMap<String, Object> assignExpressionMap = new HashMap<String, Object>();
        assignExpressionMap.put("weight", new DoubleLiteralExpr(weight));
        assignExpressionMap.put("id", new StringLiteralExpr(segmentName));
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor((ConstructorDeclaration)constructorDeclaration, (String)generatedClassName, superInvocationExpressionsMap, assignExpressionMap));
    }

    private void commonEvaluateSegment(KiePMMLSegment toEvaluate, Segment segment) {
        Assert.assertNotNull((Object)toEvaluate);
        Assert.assertEquals((Object)segment.getId(), (Object)toEvaluate.getName());
        Assert.assertEquals((Object)segment.getPredicate().getClass().getSimpleName(), (Object)toEvaluate.getKiePMMLPredicate().getName());
        Assert.assertNotNull((Object)toEvaluate.getModel());
    }

    private void commonEvaluateMap(Map<String, String> toEvaluate, Segment segment) {
        Assert.assertNotNull(toEvaluate);
    }

    private void commonEvaluateNestedModels(List<KiePMMLModel> toEvaluate) {
        Assert.assertFalse((boolean)toEvaluate.isEmpty());
        toEvaluate.forEach(kiePMMLModel -> Assert.assertTrue((boolean)(kiePMMLModel instanceof HasSourcesMap)));
    }
}

