/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.mining.compiler.HasKnowledgeBuilderMock;
import org.kie.pmml.models.mining.compiler.dto.MiningModelCompilationDTO;
import org.kie.pmml.models.mining.compiler.factories.AbstractKiePMMLFactoryTest;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLMiningModelFactory;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.xml.sax.SAXException;

public class KiePMMLMiningModelFactoryTest
extends AbstractKiePMMLFactoryTest {
    private static final String TEMPLATE_SOURCE = "KiePMMLMiningModelTemplate.tmpl";
    private static final String TEMPLATE_CLASS_NAME = "KiePMMLMiningModelTemplate";
    private static CompilationUnit COMPILATION_UNIT;
    private static ClassOrInterfaceDeclaration MODEL_TEMPLATE;

    @BeforeClass
    public static void setup() throws IOException, JAXBException, SAXException {
        KiePMMLMiningModelFactoryTest.innerSetup();
        COMPILATION_UNIT = JavaParserUtils.getFromFileName((String)TEMPLATE_SOURCE);
        MODEL_TEMPLATE = (ClassOrInterfaceDeclaration)COMPILATION_UNIT.getClassByName(TEMPLATE_CLASS_NAME).get();
    }

    @Test
    public void getKiePMMLMiningModel() {
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (HasClassLoader)new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER));
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        KiePMMLMiningModel retrieved = KiePMMLMiningModelFactory.getKiePMMLMiningModel((MiningModelCompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)MINING_MODEL.getAlgorithmName(), (Object)retrieved.getAlgorithmName());
        Assert.assertEquals((Object)MINING_MODEL.isScorable(), (Object)retrieved.isScorable());
        Assert.assertEquals((Object)targetFieldName, (Object)retrieved.getTargetField());
    }

    @Test
    public void getKiePMMLMiningModelSourcesMap() {
        ArrayList nestedModels = new ArrayList();
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (HasClassLoader)new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER));
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        Map retrieved = KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMap((MiningModelCompilationDTO)compilationDTO, nestedModels);
        Assert.assertNotNull((Object)retrieved);
        int expectedNestedModels = MINING_MODEL.getSegmentation().getSegments().size();
        Assert.assertEquals((long)expectedNestedModels, (long)nestedModels.size());
    }

    @Test
    public void getKiePMMLMiningModelSourcesMapCompiled() {
        ArrayList nestedModels = new ArrayList();
        HasKnowledgeBuilderMock hasKnowledgeBuilderMock = new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER);
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (HasClassLoader)hasKnowledgeBuilderMock);
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        List<String> expectedGeneratedClasses = MINING_MODEL.getSegmentation().getSegments().stream().map(segment -> {
            String modelName = segment.getModel().getModelName();
            String sanitizedPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)(compilationDTO.getSegmentationPackageName() + "." + segment.getId()));
            String sanitizedClassName = KiePMMLModelUtils.getSanitizedClassName((String)modelName);
            return String.format("%s.%s", sanitizedPackageName, sanitizedClassName);
        }).collect(Collectors.toList());
        expectedGeneratedClasses.forEach(expectedGeneratedClass -> {
            try {
                hasKnowledgeBuilderMock.getClassLoader().loadClass((String)expectedGeneratedClass);
                Assert.fail((String)("Expecting class not found: " + expectedGeneratedClass));
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof ClassNotFoundException));
            }
        });
        Map retrieved = KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMapCompiled((MiningModelCompilationDTO)compilationDTO, nestedModels);
        Assert.assertNotNull((Object)retrieved);
        int expectedNestedModels = MINING_MODEL.getSegmentation().getSegments().size();
        Assert.assertEquals((long)expectedNestedModels, (long)nestedModels.size());
        expectedGeneratedClasses.forEach(expectedGeneratedClass -> {
            try {
                hasKnowledgeBuilderMock.getClassLoader().loadClass((String)expectedGeneratedClass);
            }
            catch (Exception e) {
                Assert.fail((String)("Expecting class to be loaded, but got: " + e.getClass().getName() + " -> " + e.getMessage()));
                e.printStackTrace();
            }
        });
    }

    @Test
    public void setConstructor() {
        PMML_MODEL pmmlModel = PMML_MODEL.byName((String)MINING_MODEL.getClass().getSimpleName());
        ClassOrInterfaceDeclaration modelTemplate = MODEL_TEMPLATE.clone();
        MINING_FUNCTION miningFunction = MINING_FUNCTION.byName((String)MINING_MODEL.getMiningFunction().value());
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (HasClassLoader)new HasClassLoaderMock());
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        KiePMMLMiningModelFactory.setConstructor((MiningModelCompilationDTO)compilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
        HashMap<Integer, NameExpr> superInvocationExpressionsMap = new HashMap<Integer, NameExpr>();
        superInvocationExpressionsMap.put(0, new NameExpr(String.format("\"%s\"", MINING_MODEL.getModelName())));
        HashMap<String, Object> assignExpressionMap = new HashMap<String, Object>();
        assignExpressionMap.put("targetField", new StringLiteralExpr(targetFieldName));
        assignExpressionMap.put("miningFunction", new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
        assignExpressionMap.put("pmmlMODEL", new NameExpr(pmmlModel.getClass().getName() + "." + pmmlModel.name()));
        ClassOrInterfaceType kiePMMLSegmentationClass = StaticJavaParser.parseClassOrInterfaceType((String)compilationDTO.getSegmentationCanonicalClassName());
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentationClass);
        assignExpressionMap.put("segmentation", objectCreationExpr);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().get();
        Assert.assertTrue((boolean)CodegenTestUtils.commonEvaluateConstructor((ConstructorDeclaration)constructorDeclaration, (String)KiePMMLModelUtils.getSanitizedClassName((String)MINING_MODEL.getModelName()), superInvocationExpressionsMap, assignExpressionMap));
    }
}

