/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.executor;

import java.io.Externalizable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.util.ClassUtils;
import org.junit.Test;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.mocks.ExternalizableMock;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.models.mining.compiler.HasKnowledgeBuilderMock;
import org.kie.pmml.models.mining.compiler.executor.MiningModelImplementationProvider;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.kie.pmml.models.mining.model.KiePMMLMiningModelWithSources;
import org.kie.test.util.filesystem.FileUtils;

public class MiningModelImplementationProviderTest {
    private static final MiningModelImplementationProvider PROVIDER = new MiningModelImplementationProvider();
    private static final String SOURCE_REGRESSION = "MiningModel_Regression.pmml";
    private static final String SOURCE_TREE = "MiningModel_TreeModel.pmml";
    private static final String SOURCE_SCORECARD = "MiningModel_Scorecard.pmml";
    private static final String SOURCE_MIXED = "MiningModel_Mixed.pmml";
    private static final String SOURCE_NO_SEGMENT_ID = "MiningModel_NoSegmentId.pmml";
    private static final String SOURCE_SEGMENT_ID = "MiningModel_SegmentId.pmml";

    @Test
    public void getPMMLModelType() {
        Assertions.assertThat((Comparable)PROVIDER.getPMMLModelType()).isEqualTo((Object)PMML_MODEL.MINING_MODEL);
    }

    @Test
    public void getKiePMMLModelRegression() throws Exception {
        this.commonGetKiePMMLModel(SOURCE_REGRESSION);
    }

    @Test
    public void getKiePMMLModelTree() throws Exception {
        this.commonGetKiePMMLModel(SOURCE_TREE);
    }

    @Test
    public void getKiePMMLModelScorecard() throws Exception {
        this.commonGetKiePMMLModel(SOURCE_SCORECARD);
    }

    @Test
    public void getKiePMMLModelMixed() throws Exception {
        this.commonGetKiePMMLModel(SOURCE_MIXED);
    }

    @Test
    public void getKiePMMLModelWithSourcesRegression() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_REGRESSION);
    }

    @Test
    public void getKiePMMLModelWithSourcesTree() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_TREE);
    }

    @Test
    public void getKiePMMLModelWithSourcesScorecard() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_SCORECARD);
    }

    @Test
    public void getKiePMMLModelWithSourcesMixed() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_MIXED);
    }

    @Test
    public void populateMissingIds() throws Exception {
        this.commonVerifySegmentId(SOURCE_NO_SEGMENT_ID);
        this.commonVerifySegmentId(SOURCE_SEGMENT_ID);
    }

    private void commonVerifySegmentId(String source) throws Exception {
        PMML pmml = this.getPMML(source);
        MiningModel miningModel = (MiningModel)pmml.getModels().get(0);
        this.commonVerifySegmentId(miningModel.getSegmentation().getSegments());
    }

    private void commonVerifySegmentId(List<Segment> segments) {
        for (Segment segment : segments) {
            Assertions.assertThat((String)segment.getId()).isNotNull();
            if (!(segment.getModel() instanceof MiningModel)) continue;
            this.commonVerifySegmentId(((MiningModel)segment.getModel()).getSegmentation().getSegments());
        }
    }

    private void commonGetKiePMMLModel(String source) throws Exception {
        PMML pmml = this.getPMML(source);
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        MiningModel miningmodel = (MiningModel)pmml.getModels().get(0);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)miningmodel, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        KiePMMLMiningModel retrieved = PROVIDER.getKiePMMLModel((CompilationDTO)compilationDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isInstanceOf(Serializable.class);
        this.commonVerifyIsDeepCloneable((AbstractKiePMMLComponent)retrieved);
    }

    private void commonGetKiePMMLModelWithSources(String source) throws Exception {
        PMML pmml = this.getPMML(source);
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        MiningModel miningmodel = (MiningModel)pmml.getModels().get(0);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)miningmodel, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        KiePMMLMiningModelWithSources retrieved = (KiePMMLMiningModelWithSources)PROVIDER.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        this.commonVerifyIsDeepCloneable((AbstractKiePMMLComponent)retrieved);
        Assertions.assertThat((List)retrieved.getNestedModels()).isNotNull();
        Assertions.assertThat((List)retrieved.getNestedModels()).isNotEmpty();
        HashMap sourcesMap = new HashMap(retrieved.getSourcesMap());
        Assertions.assertThat(sourcesMap).isNotEmpty();
        try {
            KieMemoryCompiler.compile(sourcesMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
            Assertions.fail((String)"Expecting compilation error without nested models sources");
        }
        catch (Exception exception) {
            // empty catch block
        }
        retrieved.getNestedModels().forEach(nestedModel -> sourcesMap.putAll(((HasSourcesMap)nestedModel).getSourcesMap()));
        try {
            KieMemoryCompiler.compile(sourcesMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    private PMML getPMML(String source) throws Exception {
        FileInputStream fis = FileUtils.getFileInputStream((String)source);
        PMML toReturn = KiePMMLUtil.load((InputStream)fis, (String)source);
        Assertions.assertThat((Object)toReturn).isNotNull();
        Assertions.assertThat((List)toReturn.getModels()).hasSize(1);
        Assertions.assertThat((Object)((Model)toReturn.getModels().get(0))).isInstanceOf(MiningModel.class);
        return toReturn;
    }

    private void commonVerifyIsDeepCloneable(AbstractKiePMMLComponent toVerify) {
        Assertions.assertThat((Object)toVerify).isInstanceOf(Serializable.class);
        ExternalizableMock externalizableMock = new ExternalizableMock();
        externalizableMock.setKiePMMLComponent(toVerify);
        ClassUtils.deepClone((Externalizable)externalizableMock);
    }
}

