/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.junit.Before;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;
import org.xml.sax.SAXException;

public abstract class AbstractKiePMMLFactoryTest {
    protected static final String SOURCE_MIXED = "MiningModel_Mixed.pmml";
    protected static DataDictionary DATA_DICTIONARY;
    protected static TransformationDictionary TRANSFORMATION_DICTIONARY;
    protected static PMML pmml;
    protected static MiningModel MINING_MODEL;
    protected static List<DerivedField> DERIVED_FIELDS;
    protected static KnowledgeBuilderImpl KNOWLEDGE_BUILDER;
    protected static String targetFieldName;

    protected static void innerSetup() throws JAXBException, SAXException, IOException {
        FileInputStream fis = FileUtils.getFileInputStream((String)SOURCE_MIXED);
        pmml = KiePMMLUtil.load((InputStream)fis, (String)SOURCE_MIXED);
        Assertions.assertThat((Object)pmml).isNotNull();
        DATA_DICTIONARY = pmml.getDataDictionary();
        Assertions.assertThat((Object)DATA_DICTIONARY).isNotNull();
        TRANSFORMATION_DICTIONARY = pmml.getTransformationDictionary();
        Assertions.assertThat((Object)((Model)pmml.getModels().get(0))).isInstanceOf(MiningModel.class);
        MINING_MODEL = (MiningModel)pmml.getModels().get(0);
        Assertions.assertThat((Object)MINING_MODEL).isNotNull();
        AbstractKiePMMLFactoryTest.populateMissingIds(MINING_MODEL);
        DERIVED_FIELDS = ModelUtils.getDerivedFields((TransformationDictionary)TRANSFORMATION_DICTIONARY, (LocalTransformations)MINING_MODEL.getLocalTransformations());
        List fields = ModelUtils.getFieldsFromDataDictionaryAndTransformationDictionary((DataDictionary)DATA_DICTIONARY, (TransformationDictionary)TRANSFORMATION_DICTIONARY);
        targetFieldName = (String)ModelUtils.getTargetFieldName((List)fields, (Model)MINING_MODEL).get();
    }

    @Before
    public void init() {
        KNOWLEDGE_BUILDER = new KnowledgeBuilderImpl();
    }

    protected String getExpectedNestedModelClass(Segment segment) {
        String basePackage = KiePMMLModelUtils.getSanitizedPackageName((String)String.format("%s.%s", "PACKAGE_NAME", MINING_MODEL.getModelName()));
        String segmentationName = String.format("%s_Segmentation", MINING_MODEL.getModelName());
        String segmentationPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)(basePackage + "." + segmentationName));
        String segmentModelPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)(segmentationPackageName + "." + segment.getId()));
        String simpleClassName = KiePMMLModelUtils.getSanitizedClassName((String)segment.getModel().getModelName());
        return String.format("%s.%s", segmentModelPackageName, simpleClassName);
    }

    private static void populateMissingIds(MiningModel model) {
        List segments = model.getSegmentation().getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            Segment segment = (Segment)segments.get(i);
            if (segment.getId() != null && !segment.getId().isEmpty()) continue;
            String toSet = String.format("%sSegment%s", model.getModelName(), i);
            segment.setId(toSet);
            if (!(segment.getModel() instanceof MiningModel)) continue;
            AbstractKiePMMLFactoryTest.populateMissingIds((MiningModel)segment.getModel());
        }
    }
}

