/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.executor;

import java.io.Externalizable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.util.ClassUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.mocks.ExternalizableMock;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.models.mining.compiler.HasKnowledgeBuilderMock;
import org.kie.pmml.models.mining.compiler.executor.MiningModelImplementationProvider;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.kie.pmml.models.mining.model.KiePMMLMiningModelWithSources;
import org.kie.test.util.filesystem.FileUtils;

public class MiningModelImplementationProviderTest {
    private static final MiningModelImplementationProvider PROVIDER = new MiningModelImplementationProvider();
    private static final String SOURCE_REGRESSION = "MiningModel_Regression.pmml";
    private static final String SOURCE_TREE = "MiningModel_TreeModel.pmml";
    private static final String SOURCE_SCORECARD = "MiningModel_Scorecard.pmml";
    private static final String SOURCE_MIXED = "MiningModel_Mixed.pmml";
    private static final String SOURCE_NO_SEGMENT_ID = "MiningModel_NoSegmentId.pmml";
    private static final String SOURCE_SEGMENT_ID = "MiningModel_SegmentId.pmml";

    @Test
    public void getPMMLModelType() {
        Assert.assertEquals((Object)PMML_MODEL.MINING_MODEL, (Object)PROVIDER.getPMMLModelType());
    }

    @Test
    public void getKiePMMLModelRegression() throws Exception {
        this.commonGetKiePMMLModel(SOURCE_REGRESSION);
    }

    @Test
    public void getKiePMMLModelTree() throws Exception {
        this.commonGetKiePMMLModel(SOURCE_TREE);
    }

    @Test
    public void getKiePMMLModelScorecard() throws Exception {
        this.commonGetKiePMMLModel(SOURCE_SCORECARD);
    }

    @Test
    public void getKiePMMLModelMixed() throws Exception {
        this.commonGetKiePMMLModel(SOURCE_MIXED);
    }

    @Test
    public void getKiePMMLModelWithSourcesRegression() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_REGRESSION);
    }

    @Test
    public void getKiePMMLModelWithSourcesTree() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_TREE);
    }

    @Test
    public void getKiePMMLModelWithSourcesScorecard() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_SCORECARD);
    }

    @Test
    public void getKiePMMLModelWithSourcesMixed() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_MIXED);
    }

    @Test
    public void populateMissingIds() throws Exception {
        this.commonVerifySegmentId(SOURCE_NO_SEGMENT_ID);
        this.commonVerifySegmentId(SOURCE_SEGMENT_ID);
    }

    private void commonVerifySegmentId(String source) throws Exception {
        PMML pmml = this.getPMML(source);
        MiningModel miningModel = (MiningModel)pmml.getModels().get(0);
        this.commonVerifySegmentId(miningModel.getSegmentation().getSegments());
    }

    private void commonVerifySegmentId(List<Segment> segments) {
        for (Segment segment : segments) {
            Assert.assertNotNull((Object)segment.getId());
            if (!(segment.getModel() instanceof MiningModel)) continue;
            this.commonVerifySegmentId(((MiningModel)segment.getModel()).getSegmentation().getSegments());
        }
    }

    private void commonGetKiePMMLModel(String source) throws Exception {
        PMML pmml = this.getPMML(source);
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        MiningModel miningmodel = (MiningModel)pmml.getModels().get(0);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)miningmodel, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        KiePMMLMiningModel retrieved = PROVIDER.getKiePMMLModel((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)(retrieved instanceof Serializable));
        this.commonVerifyIsDeepCloneable((AbstractKiePMMLComponent)retrieved);
    }

    private void commonGetKiePMMLModelWithSources(String source) throws Exception {
        PMML pmml = this.getPMML(source);
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        MiningModel miningmodel = (MiningModel)pmml.getModels().get(0);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)miningmodel, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        KiePMMLMiningModelWithSources retrieved = (KiePMMLMiningModelWithSources)PROVIDER.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        this.commonVerifyIsDeepCloneable((AbstractKiePMMLComponent)retrieved);
        Assert.assertNotNull((Object)retrieved.getNestedModels());
        Assert.assertFalse((boolean)retrieved.getNestedModels().isEmpty());
        HashMap sourcesMap = new HashMap(retrieved.getSourcesMap());
        Assert.assertFalse((boolean)sourcesMap.isEmpty());
        try {
            KieMemoryCompiler.compile(sourcesMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
            Assert.fail((String)"Expecting compilation error without nested models sources");
        }
        catch (Exception exception) {
            // empty catch block
        }
        retrieved.getNestedModels().forEach(nestedModel -> sourcesMap.putAll(((HasSourcesMap)nestedModel).getSourcesMap()));
        try {
            KieMemoryCompiler.compile(sourcesMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private PMML getPMML(String source) throws Exception {
        FileInputStream fis = FileUtils.getFileInputStream((String)source);
        PMML toReturn = KiePMMLUtil.load((InputStream)fis, (String)source);
        Assert.assertNotNull((Object)toReturn);
        Assert.assertEquals((long)1L, (long)toReturn.getModels().size());
        Assert.assertTrue((boolean)(toReturn.getModels().get(0) instanceof MiningModel));
        return toReturn;
    }

    private void commonVerifyIsDeepCloneable(AbstractKiePMMLComponent toVerify) {
        Assert.assertTrue((boolean)(toVerify instanceof Serializable));
        ExternalizableMock externalizableMock = new ExternalizableMock();
        externalizableMock.setKiePMMLComponent(toVerify);
        ClassUtils.deepClone((Externalizable)externalizableMock);
    }
}

