/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.models.mining.compiler.HasKnowledgeBuilderMock;
import org.kie.pmml.models.mining.compiler.dto.MiningModelCompilationDTO;
import org.kie.pmml.models.mining.compiler.factories.AbstractKiePMMLFactoryTest;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLSegmentationFactory;
import org.xml.sax.SAXException;

public class KiePMMLSegmentationFactoryTest
extends AbstractKiePMMLFactoryTest {
    @BeforeClass
    public static void setup() throws IOException, JAXBException, SAXException {
        KiePMMLSegmentationFactoryTest.innerSetup();
    }

    @Test
    public void getSegmentationSourcesMap() {
        ArrayList nestedModels = new ArrayList();
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (HasClassLoader)new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER));
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        Map retrieved = KiePMMLSegmentationFactory.getSegmentationSourcesMap((MiningModelCompilationDTO)compilationDTO, nestedModels);
        Assert.assertNotNull((Object)retrieved);
        int expectedNestedModels = MINING_MODEL.getSegmentation().getSegments().size();
        Assert.assertEquals((long)expectedNestedModels, (long)nestedModels.size());
    }

    @Test
    public void getSegmentationSourcesMapCompiled() {
        HasKnowledgeBuilderMock hasKnowledgeBuilderMock = new HasKnowledgeBuilderMock(KNOWLEDGE_BUILDER);
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (HasClassLoader)hasKnowledgeBuilderMock);
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        ArrayList nestedModels = new ArrayList();
        List<String> expectedGeneratedClasses = MINING_MODEL.getSegmentation().getSegments().stream().map(this::getExpectedNestedModelClass).collect(Collectors.toList());
        expectedGeneratedClasses.forEach(expectedGeneratedClass -> {
            try {
                hasKnowledgeBuilderMock.getClassLoader().loadClass((String)expectedGeneratedClass);
                Assert.fail((String)("Expecting class not found: " + expectedGeneratedClass));
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof ClassNotFoundException));
            }
        });
        Map retrieved = KiePMMLSegmentationFactory.getSegmentationSourcesMapCompiled((MiningModelCompilationDTO)compilationDTO, nestedModels);
        Assert.assertNotNull((Object)retrieved);
        int expectedNestedModels = MINING_MODEL.getSegmentation().getSegments().size();
        Assert.assertEquals((long)expectedNestedModels, (long)nestedModels.size());
        expectedGeneratedClasses.forEach(expectedGeneratedClass -> {
            try {
                hasKnowledgeBuilderMock.getClassLoader().loadClass((String)expectedGeneratedClass);
            }
            catch (Exception e) {
                Assert.fail((String)("Expecting class to be loaded, but got: " + e.getClass().getName() + " -> " + e.getMessage()));
                e.printStackTrace();
            }
        });
    }
}

