/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.executor;

import java.io.Externalizable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.drools.base.util.CloneUtil;
import org.drools.util.FileUtils;
import org.junit.jupiter.api.Test;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.compilation.PMMLCompilationContext;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.mocks.ExternalizableMock;
import org.kie.pmml.compiler.commons.mocks.PMMLCompilationContextMock;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.models.mining.compiler.executor.MiningModelImplementationProvider;
import org.kie.pmml.models.mining.model.KiePMMLMiningModelWithSources;

public class MiningModelImplementationProviderTest {
    private static final MiningModelImplementationProvider PROVIDER = new MiningModelImplementationProvider();
    private static final String SOURCE_REGRESSION = "MiningModel_Regression.pmml";
    private static final String SOURCE_TREE = "MiningModel_TreeModel.pmml";
    private static final String SOURCE_SCORECARD = "MiningModel_Scorecard.pmml";
    private static final String SOURCE_MIXED = "MiningModel_Mixed.pmml";
    private static final String SOURCE_NO_SEGMENT_ID = "MiningModel_NoSegmentId.pmml";
    private static final String SOURCE_SEGMENT_ID = "MiningModel_SegmentId.pmml";

    @Test
    void getPMMLModelType() {
        Assertions.assertThat((Comparable)PROVIDER.getPMMLModelType()).isEqualTo((Object)PMML_MODEL.MINING_MODEL);
    }

    @Test
    void getKiePMMLModelWithSourcesRegression() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_REGRESSION);
    }

    @Test
    void getKiePMMLModelWithSourcesTree() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_TREE);
    }

    @Test
    void getKiePMMLModelWithSourcesScorecard() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_SCORECARD);
    }

    @Test
    void getKiePMMLModelWithSourcesMixed() throws Exception {
        this.commonGetKiePMMLModelWithSources(SOURCE_MIXED);
    }

    @Test
    void populateMissingIds() throws Exception {
        this.commonVerifySegmentId(SOURCE_NO_SEGMENT_ID);
        this.commonVerifySegmentId(SOURCE_SEGMENT_ID);
    }

    private void commonVerifySegmentId(String source) throws Exception {
        PMML pmml = this.getPMML(source);
        MiningModel miningModel = (MiningModel)pmml.getModels().get(0);
        this.commonVerifySegmentId(miningModel.getSegmentation().getSegments());
    }

    private void commonVerifySegmentId(List<Segment> segments) {
        for (Segment segment : segments) {
            Assertions.assertThat((String)segment.getId()).isNotNull();
            if (!(segment.getModel() instanceof MiningModel)) continue;
            this.commonVerifySegmentId(((MiningModel)segment.getModel()).getSegmentation().getSegments());
        }
    }

    private void commonGetKiePMMLModelWithSources(String source) throws Exception {
        PMML pmml = this.getPMML(source);
        MiningModel miningmodel = (MiningModel)pmml.getModels().get(0);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)miningmodel, (PMMLCompilationContext)new PMMLCompilationContextMock(), (String)source);
        KiePMMLMiningModelWithSources retrieved = (KiePMMLMiningModelWithSources)PROVIDER.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        this.commonVerifyIsDeepCloneable((AbstractKiePMMLComponent)retrieved);
        Assertions.assertThat((List)retrieved.getNestedModels()).isNotNull();
        Assertions.assertThat((List)retrieved.getNestedModels()).isNotEmpty();
        HashMap sourcesMap = new HashMap(retrieved.getSourcesMap());
        Assertions.assertThat(sourcesMap).isNotEmpty();
        retrieved.getNestedModels().forEach(nestedModel -> sourcesMap.putAll(((HasSourcesMap)nestedModel).getSourcesMap()));
        try {
            KieMemoryCompiler.compile(sourcesMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    private PMML getPMML(String source) throws Exception {
        FileInputStream fis = FileUtils.getFileInputStream((String)source);
        PMML toReturn = KiePMMLUtil.load((InputStream)fis, (String)source);
        Assertions.assertThat((Object)toReturn).isNotNull();
        Assertions.assertThat((List)toReturn.getModels()).hasSize(1);
        Assertions.assertThat((Object)((Model)toReturn.getModels().get(0))).isInstanceOf(MiningModel.class);
        return toReturn;
    }

    private void commonVerifyIsDeepCloneable(AbstractKiePMMLComponent toVerify) {
        Assertions.assertThat((Object)toVerify).isInstanceOf(Serializable.class);
        ExternalizableMock externalizableMock = new ExternalizableMock();
        externalizableMock.setKiePMMLComponent(toVerify);
        CloneUtil.deepClone((Externalizable)externalizableMock);
    }
}

