/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.compilation.PMMLCompilationContext;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.mocks.PMMLCompilationContextMock;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.mining.compiler.dto.MiningModelCompilationDTO;
import org.kie.pmml.models.mining.compiler.factories.AbstractKiePMMLFactoryTest;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLMiningModelFactory;
import org.xml.sax.SAXException;

public class KiePMMLMiningModelFactoryTest
extends AbstractKiePMMLFactoryTest {
    private static final String TEMPLATE_SOURCE = "KiePMMLMiningModelTemplate.tmpl";
    private static final String TEMPLATE_CLASS_NAME = "KiePMMLMiningModelTemplate";
    private static CompilationUnit COMPILATION_UNIT;
    private static ClassOrInterfaceDeclaration MODEL_TEMPLATE;

    @BeforeAll
    public static void setup() throws IOException, JAXBException, SAXException {
        KiePMMLMiningModelFactoryTest.innerSetup();
        COMPILATION_UNIT = JavaParserUtils.getFromFileName((String)TEMPLATE_SOURCE);
        MODEL_TEMPLATE = (ClassOrInterfaceDeclaration)COMPILATION_UNIT.getClassByName(TEMPLATE_CLASS_NAME).get();
    }

    @Test
    void getKiePMMLMiningModelSourcesMap() {
        ArrayList nestedModels = new ArrayList();
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (PMMLCompilationContext)new PMMLCompilationContextMock(), (String)"FILE_NAME");
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        Map retrieved = KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMap((MiningModelCompilationDTO)compilationDTO, nestedModels);
        Assertions.assertThat((Map)retrieved).isNotNull();
        int expectedNestedModels = MINING_MODEL.getSegmentation().getSegments().size();
        Assertions.assertThat(nestedModels).hasSize(expectedNestedModels);
    }

    @Test
    void setConstructor() {
        PMML_MODEL pmmlModel = PMML_MODEL.byName((String)MINING_MODEL.getClass().getSimpleName());
        ClassOrInterfaceDeclaration modelTemplate = MODEL_TEMPLATE.clone();
        MINING_FUNCTION miningFunction = MINING_FUNCTION.byName((String)MINING_MODEL.getMiningFunction().value());
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (PMMLCompilationContext)new PMMLCompilationContextMock(), (String)"FILENAME");
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        KiePMMLMiningModelFactory.setConstructor((MiningModelCompilationDTO)compilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
        HashMap<Integer, NameExpr> superInvocationExpressionsMap = new HashMap<Integer, NameExpr>();
        superInvocationExpressionsMap.put(0, new NameExpr(String.format("\"%s\"", "FILENAME")));
        superInvocationExpressionsMap.put(1, new NameExpr(String.format("\"%s\"", MINING_MODEL.getModelName())));
        HashMap<String, Object> assignExpressionMap = new HashMap<String, Object>();
        assignExpressionMap.put("targetField", new StringLiteralExpr(targetFieldName));
        assignExpressionMap.put("miningFunction", new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
        assignExpressionMap.put("pmmlMODEL", new NameExpr(pmmlModel.getClass().getName() + "." + pmmlModel.name()));
        ClassOrInterfaceType kiePMMLSegmentationClass = StaticJavaParser.parseClassOrInterfaceType((String)compilationDTO.getSegmentationCanonicalClassName());
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentationClass);
        assignExpressionMap.put("segmentation", objectCreationExpr);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().get();
        Assertions.assertThat((boolean)CodegenTestUtils.commonEvaluateConstructor((ConstructorDeclaration)constructorDeclaration, (String)KiePMMLModelUtils.getSanitizedClassName((String)MINING_MODEL.getModelName()), superInvocationExpressionsMap, assignExpressionMap)).isTrue();
    }
}

