/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.Segment;
import org.drools.util.FileUtils;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.compilation.PMMLCompilationContext;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.mocks.PMMLCompilationContextMock;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.mining.compiler.dto.MiningModelCompilationDTO;
import org.kie.pmml.models.mining.compiler.dto.SegmentCompilationDTO;
import org.kie.pmml.models.mining.compiler.factories.AbstractKiePMMLFactoryTest;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLSegmentFactory;
import org.xml.sax.SAXException;

public class KiePMMLSegmentFactoryTest
extends AbstractKiePMMLFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLSegmentFactoryTest_01.txt";
    private static CompilationUnit COMPILATION_UNIT_BASE;
    private static ClassOrInterfaceDeclaration MODEL_TEMPLATE;

    @BeforeAll
    public static void setup() throws IOException, JAXBException, SAXException {
        KiePMMLSegmentFactoryTest.innerSetup();
        COMPILATION_UNIT_BASE = JavaParserUtils.getFromFileName((String)"KiePMMLSegmentTemplate.tmpl");
    }

    @BeforeEach
    public void initLocal() throws IOException, JAXBException, SAXException {
        CompilationUnit cloned = COMPILATION_UNIT_BASE.clone();
        MODEL_TEMPLATE = (ClassOrInterfaceDeclaration)cloned.getClassByName("KiePMMLSegmentTemplate").get();
    }

    @Test
    void getSegmentsSourcesMap() {
        List segments = MINING_MODEL.getSegmentation().getSegments();
        ArrayList<KiePMMLModel> nestedModels = new ArrayList<KiePMMLModel>();
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (PMMLCompilationContext)new PMMLCompilationContextMock(), (String)"FILENAME");
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        Map retrieved = KiePMMLSegmentFactory.getSegmentsSourcesMap((MiningModelCompilationDTO)compilationDTO, nestedModels);
        Assertions.assertThat((Map)retrieved).isNotNull();
        this.commonEvaluateNestedModels(nestedModels);
        for (Segment segment : segments) {
            this.commonEvaluateMap(retrieved, segment);
        }
    }

    @Test
    void getSegmentSourcesMap() {
        Segment segment = (Segment)MINING_MODEL.getSegmentation().getSegments().get(0);
        ArrayList<KiePMMLModel> nestedModels = new ArrayList<KiePMMLModel>();
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (PMMLCompilationContext)new PMMLCompilationContextMock(), (String)"FILENAME");
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        SegmentCompilationDTO segmentCompilationDTO = SegmentCompilationDTO.fromGeneratedPackageNameAndFields((MiningModelCompilationDTO)compilationDTO, (Segment)segment, (List)compilationDTO.getFields());
        Map retrieved = KiePMMLSegmentFactory.getSegmentSourcesMap((SegmentCompilationDTO)segmentCompilationDTO, nestedModels);
        this.commonEvaluateNestedModels(nestedModels);
        this.commonEvaluateMap(retrieved, segment);
    }

    @Test
    void getSegmentSourcesMapHasSourcesWithKiePMMLModelClass() {
        Segment segment = (Segment)MINING_MODEL.getSegmentation().getSegments().get(0);
        String regressionModelName = "CategoricalVariablesRegression";
        String kiePMMLModelClass = "PACKAGE_NAME.CategoricalVariablesRegression";
        HashMap<String, String> sourcesMap = new HashMap<String, String>();
        sourcesMap.put("PACKAGE_NAME.CategoricalVariablesRegression", String.format("public class %s {}", "CategoricalVariablesRegression"));
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (PMMLCompilationContext)new PMMLCompilationContextMock(), (String)"FILENAME");
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        SegmentCompilationDTO segmentCompilationDTO = SegmentCompilationDTO.fromGeneratedPackageNameAndFields((MiningModelCompilationDTO)compilationDTO, (Segment)segment, (List)compilationDTO.getFields());
        Map retrieved = KiePMMLSegmentFactory.getSegmentSourcesMap((SegmentCompilationDTO)segmentCompilationDTO, (boolean)true);
        this.commonEvaluateMap(retrieved, segment);
    }

    @Test
    void setConstructorNoInterpreted() {
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)MODEL_TEMPLATE.getDefaultConstructor().get();
        String segmentName = "SEGMENTNAME";
        String generatedClassName = "GENERATEDCLASSNAME";
        String kiePMMLModelClass = "KIEPMMLMODELCLASS";
        double weight = 12.22;
        KiePMMLSegmentFactory.setConstructor((String)segmentName, (String)generatedClassName, (ConstructorDeclaration)constructorDeclaration, (String)kiePMMLModelClass, (boolean)false, (double)weight);
        HashMap<Integer, NameExpr> superInvocationExpressionsMap = new HashMap<Integer, NameExpr>();
        superInvocationExpressionsMap.put(0, new NameExpr(String.format("\"%s\"", segmentName)));
        ClassOrInterfaceType classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)kiePMMLModelClass);
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(classOrInterfaceType);
        superInvocationExpressionsMap.put(3, new NameExpr(objectCreationExpr.toString()));
        HashMap<String, Object> assignExpressionMap = new HashMap<String, Object>();
        assignExpressionMap.put("weight", new DoubleLiteralExpr(weight));
        assignExpressionMap.put("id", new StringLiteralExpr(segmentName));
        Assertions.assertThat((boolean)CodegenTestUtils.commonEvaluateConstructor((ConstructorDeclaration)constructorDeclaration, (String)generatedClassName, superInvocationExpressionsMap, assignExpressionMap)).isTrue();
    }

    @Test
    void setConstructorInterpreted() throws IOException {
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)MODEL_TEMPLATE.getDefaultConstructor().get();
        String segmentName = "SEGMENTNAME";
        String generatedClassName = "GENERATEDCLASSNAME";
        String kiePMMLModelClass = "KIEPMMLMODELCLASS";
        double weight = 12.22;
        KiePMMLSegmentFactory.setConstructor((String)segmentName, (String)generatedClassName, (ConstructorDeclaration)constructorDeclaration, (String)kiePMMLModelClass, (boolean)true, (double)weight);
        HashMap<Integer, NameExpr> superInvocationExpressionsMap = new HashMap<Integer, NameExpr>();
        superInvocationExpressionsMap.put(0, new NameExpr(String.format("\"%s\"", segmentName)));
        ClassOrInterfaceType classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)kiePMMLModelClass);
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(classOrInterfaceType);
        superInvocationExpressionsMap.put(3, new NameExpr(objectCreationExpr.toString()));
        HashMap<String, Object> assignExpressionMap = new HashMap<String, Object>();
        assignExpressionMap.put("weight", new DoubleLiteralExpr(weight));
        assignExpressionMap.put("id", new StringLiteralExpr(segmentName));
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseConstructorBlock((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)constructorDeclaration.getBody())).isTrue();
    }

    private void commonEvaluateMap(Map<String, String> toEvaluate, Segment segment) {
        Assertions.assertThat(toEvaluate).isNotNull();
    }

    private void commonEvaluateNestedModels(List<KiePMMLModel> toEvaluate) {
        Assertions.assertThat(toEvaluate).isNotEmpty();
        toEvaluate.forEach(kiePMMLModel -> Assertions.assertThat((boolean)(kiePMMLModel instanceof HasSourcesMap)).isTrue());
    }
}

