/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.compilation.PMMLCompilationContext;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.mocks.PMMLCompilationContextMock;
import org.kie.pmml.models.mining.compiler.dto.MiningModelCompilationDTO;
import org.kie.pmml.models.mining.compiler.factories.AbstractKiePMMLFactoryTest;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLSegmentationFactory;
import org.xml.sax.SAXException;

public class KiePMMLSegmentationFactoryTest
extends AbstractKiePMMLFactoryTest {
    @BeforeAll
    public static void setup() throws IOException, JAXBException, SAXException {
        KiePMMLSegmentationFactoryTest.innerSetup();
    }

    @Test
    void getSegmentationSourcesMap() {
        ArrayList nestedModels = new ArrayList();
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)MINING_MODEL, (PMMLCompilationContext)new PMMLCompilationContextMock(), (String)"FILENAME");
        MiningModelCompilationDTO compilationDTO = MiningModelCompilationDTO.fromCompilationDTO((CompilationDTO)source);
        Map retrieved = KiePMMLSegmentationFactory.getSegmentationSourcesMap((MiningModelCompilationDTO)compilationDTO, nestedModels);
        Assertions.assertThat((Map)retrieved).isNotNull();
        int expectedNestedModels = MINING_MODEL.getSegmentation().getSegments().size();
        Assertions.assertThat(nestedModels).hasSize(expectedNestedModels);
    }
}

