/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.evaluator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.runtime.KieContainer;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.models.PMMLStep;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.api.runtime.PMMLListener;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.model.tuples.KiePMMLValueWeight;
import org.kie.pmml.commons.testingutility.KiePMMLTestingModel;
import org.kie.pmml.commons.testingutility.PMMLContextTest;
import org.kie.pmml.evaluator.api.exceptions.KiePMMLModelException;
import org.kie.pmml.evaluator.api.executor.PMMLRuntimeInternal;
import org.kie.pmml.models.mining.evaluator.PMMLMiningModelEvaluator;
import org.kie.pmml.models.mining.evaluator.PMMLMiningModelStep;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.kie.pmml.models.mining.model.enums.MULTIPLE_MODEL_METHOD;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegment;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegmentation;
import org.mockito.Mockito;

public class PMMLMiningModelEvaluatorTest {
    private static final List<MULTIPLE_MODEL_METHOD> RAW_OBJECT_METHODS = Arrays.asList(MULTIPLE_MODEL_METHOD.MAJORITY_VOTE, MULTIPLE_MODEL_METHOD.SELECT_ALL, MULTIPLE_MODEL_METHOD.SELECT_FIRST, MULTIPLE_MODEL_METHOD.MODEL_CHAIN);
    private static final List<MULTIPLE_MODEL_METHOD> VALUE_WEIGHT_METHODS = Arrays.asList(MULTIPLE_MODEL_METHOD.MAX, MULTIPLE_MODEL_METHOD.SUM, MULTIPLE_MODEL_METHOD.MEDIAN, MULTIPLE_MODEL_METHOD.AVERAGE, MULTIPLE_MODEL_METHOD.WEIGHTED_SUM, MULTIPLE_MODEL_METHOD.WEIGHTED_MEDIAN, MULTIPLE_MODEL_METHOD.WEIGHTED_AVERAGE);
    private static final List<MULTIPLE_MODEL_METHOD> NOT_IMPLEMENTED_METHODS = Arrays.asList(MULTIPLE_MODEL_METHOD.WEIGHTED_MAJORITY_VOTE);
    private PMMLMiningModelEvaluator evaluator;

    @Before
    public void setUp() {
        this.evaluator = new PMMLMiningModelEvaluator();
    }

    @Test
    public void getPMMLModelType() {
        Assertions.assertThat((Comparable)this.evaluator.getPMMLModelType()).isEqualTo((Object)PMML_MODEL.MINING_MODEL);
    }

    @Test
    public void getPMML4ResultOK() {
        String name = "NAME";
        String targetField = "TARGET";
        String prediction = "FIRST_VALUE";
        KiePMMLSegmentation kiePMMLSegmentation = (KiePMMLSegmentation)KiePMMLSegmentation.builder((String)"SEGM_1", Collections.emptyList(), (MULTIPLE_MODEL_METHOD)MULTIPLE_MODEL_METHOD.SELECT_FIRST).build();
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).withTargetField(targetField).withSegmentation(kiePMMLSegmentation).build();
        LinkedHashMap<String, PMMLMiningModelEvaluator.KiePMMLNameValueProbabilityMapTuple> inputData = new LinkedHashMap<String, PMMLMiningModelEvaluator.KiePMMLNameValueProbabilityMapTuple>();
        inputData.put("FIRST_KEY", new PMMLMiningModelEvaluator.KiePMMLNameValueProbabilityMapTuple(new KiePMMLNameValue("FIRST_NAME", (Object)prediction), new ArrayList()));
        inputData.put("SECOND_KEY", new PMMLMiningModelEvaluator.KiePMMLNameValueProbabilityMapTuple(new KiePMMLNameValue("SECOND_NAME", (Object)"SECOND_VALUE"), new ArrayList()));
        PMML4Result retrieved = this.evaluator.getPMML4Result(kiePMMLMiningModel, inputData, (PMMLContext)new PMMLContextTest());
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getResultCode()).isEqualTo(ResultCode.OK.getName());
        Assertions.assertThat((String)retrieved.getResultObjectName()).isEqualTo(targetField);
        Map resultVariables = retrieved.getResultVariables();
        Assertions.assertThat((Map)resultVariables).containsKey((Object)targetField);
        Assertions.assertThat(resultVariables.get(targetField)).isEqualTo((Object)prediction);
    }

    @Test
    public void getPMML4ResultFAIL() {
        String name = "NAME";
        String targetField = "TARGET";
        KiePMMLSegmentation kiePMMLSegmentation = (KiePMMLSegmentation)KiePMMLSegmentation.builder((String)"SEGM_1", Collections.emptyList(), (MULTIPLE_MODEL_METHOD)MULTIPLE_MODEL_METHOD.AVERAGE).build();
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).withTargetField(targetField).withSegmentation(kiePMMLSegmentation).build();
        LinkedHashMap<String, PMMLMiningModelEvaluator.KiePMMLNameValueProbabilityMapTuple> inputData = new LinkedHashMap<String, PMMLMiningModelEvaluator.KiePMMLNameValueProbabilityMapTuple>();
        inputData.put("FIRST_KEY", new PMMLMiningModelEvaluator.KiePMMLNameValueProbabilityMapTuple(new KiePMMLNameValue("FIRST_NAME", (Object)"FIRST_VALUE"), new ArrayList()));
        inputData.put("SECOND_KEY", new PMMLMiningModelEvaluator.KiePMMLNameValueProbabilityMapTuple(new KiePMMLNameValue("SECOND_NAME", (Object)"SECOND_VALUE"), new ArrayList()));
        PMML4Result retrieved = this.evaluator.getPMML4Result(kiePMMLMiningModel, inputData, (PMMLContext)new PMMLContextTest());
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getResultCode()).isEqualTo(ResultCode.FAIL.getName());
        Assertions.assertThat((String)retrieved.getResultObjectName()).isEqualTo(targetField);
        Map resultVariables = retrieved.getResultVariables();
        Assertions.assertThat((Map)resultVariables).containsKey((Object)targetField);
        Assertions.assertThat(resultVariables.get(targetField)).isNull();
    }

    @Test
    public void getPMMLRuntime() {
        KieServices kieServices = KieServices.Factory.get();
        KieContainer kieContainer = kieServices.newKieClasspathContainer();
        KieBase kieBase = kieContainer.getKieBase();
        String kModulePackageName = "kModulePackageNameA";
        String containerModelName = "containerModelNameA";
        PMMLRuntime firstRetrieved = this.evaluator.getPMMLRuntime(kModulePackageName, kieBase, containerModelName);
        Assertions.assertThat((Object)firstRetrieved).isNotNull();
        Assertions.assertThat((Object)firstRetrieved).isInstanceOf(PMMLRuntimeInternal.class);
        PMMLRuntimeInternal firstPMMLRuntimeInternal = (PMMLRuntimeInternal)firstRetrieved;
        PMMLRuntime secondRetrieved = this.evaluator.getPMMLRuntime(kModulePackageName, kieBase, containerModelName);
        Assertions.assertThat((Object)secondRetrieved).isInstanceOf(PMMLRuntimeInternal.class);
        PMMLRuntimeInternal secondPMMLRuntimeInternal = (PMMLRuntimeInternal)secondRetrieved;
        Assertions.assertThat((Object)secondPMMLRuntimeInternal.getKnowledgeBase()).isEqualTo((Object)firstPMMLRuntimeInternal.getKnowledgeBase());
        kModulePackageName = "kModulePackageNameB";
        containerModelName = "containerModelNameB";
        PMMLRuntime thirdRetrieved = this.evaluator.getPMMLRuntime(kModulePackageName, kieBase, containerModelName);
        Assertions.assertThat((Object)thirdRetrieved).isNotNull();
        Assertions.assertThat((Object)thirdRetrieved).isInstanceOf(PMMLRuntimeInternal.class);
        PMMLRuntimeInternal thirdPMMLRuntimeInternal = (PMMLRuntimeInternal)thirdRetrieved;
        Assertions.assertThat((Object)firstPMMLRuntimeInternal.getKnowledgeBase()).isNotEqualTo((Object)thirdPMMLRuntimeInternal.getKnowledgeBase());
    }

    @Test
    public void getKiePMMLNameRawObject() {
        String rawObject = "OBJ";
        PMML4Result pmml4Result = this.getPMML4Result(rawObject);
        RAW_OBJECT_METHODS.forEach(multipleModelMethod -> {
            KiePMMLNameValue retrieved = this.evaluator.getKiePMMLNameValue(pmml4Result, multipleModelMethod, 34.2);
            Assertions.assertThat((String)retrieved.getName()).isEqualTo(pmml4Result.getResultObjectName());
            Assertions.assertThat((Object)retrieved.getValue()).isNotNull();
            Assertions.assertThat((Object)retrieved.getValue()).isEqualTo(rawObject);
        });
    }

    @Test
    public void getKiePMMLNameValueValueWeightNumber() {
        Integer rawObject = 24;
        PMML4Result pmml4Result = this.getPMML4Result(rawObject);
        double weight = 2.23;
        double expected = rawObject.doubleValue();
        VALUE_WEIGHT_METHODS.forEach(multipleModelMethod -> {
            KiePMMLNameValue retrieved = this.evaluator.getKiePMMLNameValue(pmml4Result, multipleModelMethod, 2.23);
            Assertions.assertThat((Object)retrieved).isNotNull();
            Assertions.assertThat((String)retrieved.getName()).isEqualTo(pmml4Result.getResultObjectName());
            Assertions.assertThat((Object)retrieved.getValue()).isNotNull();
            Assertions.assertThat((Object)retrieved.getValue()).isInstanceOf(KiePMMLValueWeight.class);
            KiePMMLValueWeight kiePMMLValueWeight = (KiePMMLValueWeight)retrieved.getValue();
            Assertions.assertThat((double)kiePMMLValueWeight.getValue()).isCloseTo(expected, Offset.offset((Number)0.0));
            Assertions.assertThat((double)kiePMMLValueWeight.getWeight()).isCloseTo(2.23, Offset.offset((Number)0.0));
        });
    }

    @Test
    public void getKiePMMLNameValueWeightNoNumber() {
        PMML4Result pmml4Result = this.getPMML4Result("OBJ");
        VALUE_WEIGHT_METHODS.forEach(multipleModelMethod -> {
            try {
                this.evaluator.getKiePMMLNameValue(pmml4Result, multipleModelMethod, 34.2);
                Assertions.fail((String)(multipleModelMethod + " is supposed to throw exception because raw object is not a number"));
            }
            catch (KiePMMLException kiePMMLException) {
                // empty catch block
            }
        });
    }

    @Test
    public void getKiePMMLNameValueNotImplemented() {
        PMML4Result pmml4Result = this.getPMML4Result("OBJ");
        NOT_IMPLEMENTED_METHODS.forEach(multipleModelMethod -> {
            try {
                this.evaluator.getKiePMMLNameValue(pmml4Result, multipleModelMethod, 34.2);
                Assertions.fail((String)(multipleModelMethod + " is supposed to throw exception because not implemented"));
            }
            catch (KiePMMLException kiePMMLException) {
                // empty catch block
            }
        });
    }

    @Test
    public void getEventuallyWeightedResultRawObject() {
        String rawObject = "OBJ";
        RAW_OBJECT_METHODS.forEach(multipleModelMethod -> {
            Object retrieved = this.evaluator.getEventuallyWeightedResult(rawObject, multipleModelMethod, 34.2);
            Assertions.assertThat((Object)retrieved).isNotNull();
            Assertions.assertThat((Object)retrieved).isEqualTo(rawObject);
        });
    }

    @Test
    public void getEventuallyWeightedResultValueWeightNumber() {
        Integer rawObject = 24;
        double weight = 2.23;
        VALUE_WEIGHT_METHODS.forEach(multipleModelMethod -> {
            Object retrieved = this.evaluator.getEventuallyWeightedResult((Object)rawObject, multipleModelMethod, 2.23);
            Assertions.assertThat((Object)retrieved).isNotNull();
            Assertions.assertThat((Object)retrieved).isInstanceOf(KiePMMLValueWeight.class);
            KiePMMLValueWeight kiePMMLValueWeight = (KiePMMLValueWeight)retrieved;
            Assertions.assertThat((double)kiePMMLValueWeight.getValue()).isCloseTo(rawObject.doubleValue(), Offset.offset((Number)0.0));
            Assertions.assertThat((double)kiePMMLValueWeight.getWeight()).isCloseTo(2.23, Offset.offset((Number)0.0));
        });
    }

    @Test
    public void getEventuallyWeightedResultValueWeightNoNumber() {
        VALUE_WEIGHT_METHODS.forEach(multipleModelMethod -> {
            try {
                this.evaluator.getEventuallyWeightedResult((Object)"OBJ", multipleModelMethod, 34.2);
                Assertions.fail((String)(multipleModelMethod + " is supposed to throw exception because raw object is not a number"));
            }
            catch (KiePMMLException kiePMMLException) {
                // empty catch block
            }
        });
    }

    @Test
    public void getEventuallyWeightedResultNotImplemented() {
        NOT_IMPLEMENTED_METHODS.forEach(multipleModelMethod -> {
            try {
                this.evaluator.getEventuallyWeightedResult((Object)"OBJ", multipleModelMethod, 34.2);
                Assertions.fail((String)(multipleModelMethod + " is supposed to throw exception because not implemented"));
            }
            catch (KiePMMLException kiePMMLException) {
                // empty catch block
            }
        });
    }

    @Test
    public void validateKiePMMLMiningModel() {
        String name = "NAME";
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).withTargetField("TARGET").build();
        this.evaluator.validate((KiePMMLModel)kiePMMLMiningModel);
    }

    @Test(expected=KiePMMLModelException.class)
    public void validateNoKiePMMLMiningModel() {
        String name = "NAME";
        KiePMMLTestingModel kiePMMLModel = new KiePMMLTestingModel(name, Collections.emptyList());
        this.evaluator.validate((KiePMMLModel)kiePMMLModel);
    }

    @Test
    public void validateMiningTargetField() {
        String name = "NAME";
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).withTargetField("TARGET").build();
        this.evaluator.validateMining(kiePMMLMiningModel);
    }

    @Test(expected=KiePMMLInternalException.class)
    public void validateMiningEmptyTargetField() {
        String name = "NAME";
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).withTargetField("     ").build();
        this.evaluator.validateMining(kiePMMLMiningModel);
    }

    @Test(expected=KiePMMLInternalException.class)
    public void validateMiningNoTargetField() {
        String name = "NAME";
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).build();
        this.evaluator.validateMining(kiePMMLMiningModel);
    }

    @Test
    public void addStep() {
        PMMLStep step = (PMMLStep)Mockito.mock(PMMLStep.class);
        Set<PMMLListener> pmmlListenersMock = IntStream.range(0, 3).mapToObj(i -> (PMMLListener)Mockito.mock(PMMLListener.class)).collect(Collectors.toSet());
        PMMLContext pmmlContextMock = (PMMLContext)Mockito.mock(PMMLContext.class);
        Mockito.when((Object)pmmlContextMock.getPMMLListeners()).thenReturn(pmmlListenersMock);
        this.evaluator.addStep(() -> step, pmmlContextMock);
        pmmlListenersMock.forEach(pmmlListenerMock -> ((PMMLListener)Mockito.verify((Object)pmmlListenerMock)).stepExecuted(step));
    }

    @Test
    public void getStep() {
        String modelName = "MODEL_NAME";
        KiePMMLModel modelMock = (KiePMMLModel)Mockito.mock(KiePMMLModel.class);
        Mockito.when((Object)modelMock.getName()).thenReturn((Object)"MODEL_NAME");
        String segmentName = "SEGMENT_NAME";
        KiePMMLSegment segmentMock = (KiePMMLSegment)Mockito.mock(KiePMMLSegment.class);
        Mockito.when((Object)segmentMock.getName()).thenReturn((Object)"SEGMENT_NAME");
        Mockito.when((Object)segmentMock.getModel()).thenReturn((Object)modelMock);
        String resultObjectName = "RESULT_OBJECT_NAME";
        String resultObjectValue = "RESULT_OBJECT_VALUE";
        ResultCode resultCode = ResultCode.OK;
        PMML4Result pmml4Result = new PMML4Result();
        pmml4Result.setResultCode(resultCode.getName());
        pmml4Result.setResultObjectName("RESULT_OBJECT_NAME");
        pmml4Result.getResultVariables().put("RESULT_OBJECT_NAME", "RESULT_OBJECT_VALUE");
        PMMLStep retrieved = this.evaluator.getStep(segmentMock, pmml4Result);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isInstanceOf(PMMLMiningModelStep.class);
        Map retrievedInfo = retrieved.getInfo();
        Assertions.assertThat((Map)retrievedInfo).isNotNull();
        Assertions.assertThat(retrievedInfo.get("SEGMENT")).isEqualTo((Object)"SEGMENT_NAME");
        Assertions.assertThat(retrievedInfo.get("MODEL")).isEqualTo((Object)"MODEL_NAME");
        Assertions.assertThat(retrievedInfo.get("RESULT CODE")).isEqualTo((Object)resultCode.getName());
        Assertions.assertThat(retrievedInfo.get("RESULT")).isEqualTo((Object)"RESULT_OBJECT_VALUE");
        resultCode = ResultCode.FAIL;
        pmml4Result = new PMML4Result();
        pmml4Result.setResultCode(resultCode.getName());
        retrieved = this.evaluator.getStep(segmentMock, pmml4Result);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isInstanceOf(PMMLMiningModelStep.class);
        retrievedInfo = retrieved.getInfo();
        Assertions.assertThat((Map)retrievedInfo).isNotNull();
        Assertions.assertThat(retrievedInfo.get("SEGMENT")).isEqualTo((Object)"SEGMENT_NAME");
        Assertions.assertThat(retrievedInfo.get("MODEL")).isEqualTo((Object)"MODEL_NAME");
        Assertions.assertThat(retrievedInfo.get("RESULT CODE")).isEqualTo((Object)resultCode.getName());
        Assertions.assertThat((Map)retrievedInfo).doesNotContainKey((Object)"RESULT");
    }

    private PMML4Result getPMML4Result(Object rawObject) {
        String resultObjectName = "RESULT";
        PMML4Result toReturn = new PMML4Result();
        toReturn.addResultVariable("RESULT", rawObject);
        toReturn.setResultObjectName("RESULT");
        return toReturn;
    }
}

