/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model.segmentation;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.models.mining.model.AbstractKiePMMLMiningModelTest;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegment;

public class KiePMMLSegmentTest {
    private static final KiePMMLModel KIE_PMML_MODEL = AbstractKiePMMLMiningModelTest.getKiePMMLModel("MODEL_NAME");
    private static final KiePMMLPredicate KIE_PMML_PREDICATE = AbstractKiePMMLMiningModelTest.getKiePMMLSimplePredicate("SIMPLE_PREDICATE");
    private static final String SEGMENT_NAME = "SEGMENT_NAME";
    private static KiePMMLSegment.Builder BUILDER;
    private static KiePMMLSegment KIE_PMML_SEGMENT;

    @BeforeClass
    public static void setup() {
        BUILDER = KiePMMLSegment.builder((String)SEGMENT_NAME, Collections.emptyList(), (KiePMMLPredicate)KIE_PMML_PREDICATE, (KiePMMLModel)KIE_PMML_MODEL);
        Assertions.assertThat((Object)BUILDER).isNotNull();
        KIE_PMML_SEGMENT = (KiePMMLSegment)BUILDER.build();
        Assertions.assertThat((Object)KIE_PMML_SEGMENT).isNotNull();
    }

    @Test
    public void getWeight() {
        double weight = 33.45;
        Assertions.assertThat((double)KIE_PMML_SEGMENT.getWeight()).isCloseTo(1.0, Offset.offset((Number)0.0));
        KIE_PMML_SEGMENT = (KiePMMLSegment)BUILDER.withWeight(33.45).build();
        Assertions.assertThat((double)KIE_PMML_SEGMENT.getWeight()).isCloseTo(33.45, Offset.offset((Number)0.0));
    }

    @Test
    public void getKiePMMLPredicate() {
        Assertions.assertThat((Object)KIE_PMML_SEGMENT.getKiePMMLPredicate()).isEqualTo((Object)KIE_PMML_PREDICATE);
    }

    @Test
    public void getModel() {
        Assertions.assertThat((Object)KIE_PMML_SEGMENT.getModel()).isEqualTo((Object)KIE_PMML_MODEL);
    }
}

