/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.models.regression.model.KiePMMLRegressionModelWithSources;

public class KiePMMLRegressionModelWithSourcesTest {
    private static final String MODEL_NAME = "MODEL_NAME";
    private static final String PACKAGE_NAME = "PACKAGE_NAME";
    private static final Map<String, String> SOURCES_MAP = new HashMap<String, String>();
    private KiePMMLRegressionModelWithSources kiePMMLRegressionModelWithSources;

    @Before
    public void setup() {
        this.kiePMMLRegressionModelWithSources = new KiePMMLRegressionModelWithSources(MODEL_NAME, PACKAGE_NAME, SOURCES_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void evaluate() {
        this.kiePMMLRegressionModelWithSources.evaluate((Object)"KB", Collections.EMPTY_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getOutputFieldsMap() {
        this.kiePMMLRegressionModelWithSources.getOutputFieldsMap();
    }

    @Test
    public void getSourcesMap() {
        Assert.assertEquals(SOURCES_MAP, (Object)this.kiePMMLRegressionModelWithSources.getSourcesMap());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void addToGetSourcesMap() {
        Map retrieved = this.kiePMMLRegressionModelWithSources.getSourcesMap();
        retrieved.put("KEY", "VALUE");
    }

    @Test
    public void addSourceMap() {
        Map retrieved = this.kiePMMLRegressionModelWithSources.getSourcesMap();
        Assert.assertTrue((boolean)retrieved.isEmpty());
        this.kiePMMLRegressionModelWithSources.addSourceMap("KEY", "VALUE");
        retrieved = this.kiePMMLRegressionModelWithSources.getSourcesMap();
        Assert.assertTrue((boolean)retrieved.containsKey("KEY"));
        Assert.assertEquals((Object)"VALUE", retrieved.get("KEY"));
    }
}

