/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.DoubleUnaryOperator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.models.regression.model.KiePMMLRegressionClassificationTable;
import org.kie.pmml.models.regression.model.KiePMMLRegressionTable;

@RunWith(value=Parameterized.class)
public class KiePMMLRegressionClassificationTableTest {
    private static final DoubleUnaryOperator FIRST_ITEM_OPERATOR = aDouble -> 1.0 / aDouble;
    private static final DoubleUnaryOperator SECOND_ITEM_OPERATOR = aDouble -> 1.0 - aDouble;
    private static final String CASE_A = "caseA";
    private static final String CASE_B = "caseB";
    private static final String PROBABILITY_FALSE = String.format("probability(%s)", "caseA");
    private static final String PROBABILITY_TRUE = String.format("probability(%s)", "caseB");
    private final KiePMMLRegressionClassificationTable classificationTable;
    private final double firstTableResult;
    private final double secondTableResult;
    private final String expectedResult;

    public KiePMMLRegressionClassificationTableTest(double firstTableResult, double secondTableResult, String expectedResult) {
        this.firstTableResult = firstTableResult;
        this.secondTableResult = secondTableResult;
        this.expectedResult = expectedResult;
        this.classificationTable = this.getKiePMMLRegressionClassificationTable();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({24.5, 13.2, CASE_B}, {10.4, 16.8, CASE_B}, {0.7, 0.22, CASE_A});
    }

    @Test
    public void evaluateRegression() {
        HashMap<String, Integer> input = new HashMap<String, Integer>();
        input.put("a", 24);
        input.put("b", 32);
        Object retrieved = this.classificationTable.evaluateRegression(input);
        Assert.assertEquals((Object)this.expectedResult, (Object)retrieved);
        Map outputFieldsMap = this.classificationTable.getOutputFieldsMap();
        double expectedDouble = FIRST_ITEM_OPERATOR.applyAsDouble(this.firstTableResult);
        Assert.assertEquals((Object)expectedDouble, outputFieldsMap.get(PROBABILITY_FALSE));
        expectedDouble = SECOND_ITEM_OPERATOR.applyAsDouble(expectedDouble);
        Assert.assertEquals((Object)expectedDouble, outputFieldsMap.get(PROBABILITY_TRUE));
    }

    @Test
    public void getProbabilityMap() {
        LinkedHashMap<String, Double> resultMap = new LinkedHashMap<String, Double>();
        resultMap.put(CASE_B, this.firstTableResult);
        resultMap.put(CASE_A, this.secondTableResult);
        LinkedHashMap retrieved = this.classificationTable.getProbabilityMap(resultMap, FIRST_ITEM_OPERATOR, SECOND_ITEM_OPERATOR);
        double expectedDouble = FIRST_ITEM_OPERATOR.applyAsDouble(this.firstTableResult);
        Assert.assertEquals((double)expectedDouble, (double)((Double)retrieved.get(CASE_B)), (double)0.0);
        expectedDouble = SECOND_ITEM_OPERATOR.applyAsDouble(expectedDouble);
        Assert.assertEquals((double)expectedDouble, (double)((Double)retrieved.get(CASE_A)), (double)0.0);
    }

    @Test(expected=KiePMMLException.class)
    public void getProbabilityMapFewInput() {
        LinkedHashMap<String, Double> resultMap = new LinkedHashMap<String, Double>();
        resultMap.put(CASE_B, this.firstTableResult);
        this.classificationTable.getProbabilityMap(resultMap, FIRST_ITEM_OPERATOR, SECOND_ITEM_OPERATOR);
    }

    @Test(expected=KiePMMLException.class)
    public void getProbabilityMapTooManyInput() {
        LinkedHashMap<String, Double> resultMap = new LinkedHashMap<String, Double>();
        resultMap.put(CASE_B, this.firstTableResult);
        resultMap.put(CASE_A, this.secondTableResult);
        resultMap.put("CASE_ELSE", 444.1);
        this.classificationTable.getProbabilityMap(resultMap, FIRST_ITEM_OPERATOR, SECOND_ITEM_OPERATOR);
    }

    private KiePMMLRegressionClassificationTable getKiePMMLRegressionClassificationTable() {
        KiePMMLRegressionClassificationTable toReturn = new KiePMMLRegressionClassificationTable(){

            public boolean isBinary() {
                return true;
            }

            protected LinkedHashMap<String, Double> getProbabilityMap(LinkedHashMap<String, Double> resultMap) {
                return this.getProbabilityMap(resultMap, FIRST_ITEM_OPERATOR, SECOND_ITEM_OPERATOR);
            }

            public Object getTargetCategory() {
                return null;
            }

            protected void populateOutputFieldsMapWithProbability(Map.Entry<String, Double> predictedEntry, LinkedHashMap<String, Double> probabilityMap) {
                this.outputFieldsMap.put(PROBABILITY_FALSE, probabilityMap.get(KiePMMLRegressionClassificationTableTest.CASE_A));
                this.outputFieldsMap.put(PROBABILITY_TRUE, probabilityMap.get(KiePMMLRegressionClassificationTableTest.CASE_B));
            }

            protected void populateOutputFieldsMapWithResult(Object result) {
                this.outputFieldsMap.put("RESULT", result);
            }
        };
        toReturn.categoryTableMap.put(CASE_A, this.getKiePMMLRegressionTable(this.firstTableResult));
        toReturn.categoryTableMap.put(CASE_B, this.getKiePMMLRegressionTable(this.secondTableResult));
        return toReturn;
    }

    private KiePMMLRegressionTable getKiePMMLRegressionTable(final double returnedValue) {
        return new KiePMMLRegressionTable(){

            public Object evaluateRegression(Map<String, Object> input) {
                return returnedValue;
            }

            public Object getTargetCategory() {
                return null;
            }

            protected void updateResult(AtomicReference<Double> toUpdate) {
            }

            protected void populateOutputFieldsMapWithResult(Object result) {
            }
        };
    }
}

