/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.pmml.api.iinterfaces.SerializableFunction;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.models.regression.model.KiePMMLRegressionTable;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class KiePMMLRegressionTableTest {
    private static final String TARGET_FIELD = "TARGET_FIELD";
    private static final String FIRST_NUMERIC_INPUT = "FIRST_NUMERIC_INPUT";
    private static final String SECOND_NUMERIC_INPUT = "SECOND_NUMERIC_INPUT";
    private static final String FIRST_CATEGORICAL_INPUT = "FIRST_CATEGORICAL_INPUT";
    private static final String SECOND_CATEGORICAL_INPUT = "SECOND_CATEGORICAL_INPUT";
    private static final SerializableFunction<Double, Double> FIRST_NUMERIC_FUNCTION = (SerializableFunction & Serializable)aDouble -> 1.0 / aDouble;
    private static final SerializableFunction<Double, Double> SECOND_NUMERIC_FUNCTION = (SerializableFunction & Serializable)aDouble -> 1.0 - aDouble;
    private final KiePMMLRegressionTable regressionTable;
    private final SerializableFunction<String, Double> firstCategoricalFunction = (SerializableFunction & Serializable)aObject -> firstCategoricalResult;
    private final SerializableFunction<String, Double> secondCategoricalFunction = (SerializableFunction & Serializable)aObject -> secondCategoricalResult;
    private final double firstNumericalInput;
    private final double secondNumericalInput;
    private final double expectedResult;

    public KiePMMLRegressionTableTest(double firstNumericalInput, double secondNumericalInput, double firstCategoricalResult, double secondCategoricalResult, double expectedResult) {
        this.firstNumericalInput = firstNumericalInput;
        this.secondNumericalInput = secondNumericalInput;
        this.expectedResult = expectedResult;
        this.regressionTable = this.getKiePMMLRegressionTable();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({36.2, 11.2, 24.5, 13.2, 27.527624309392266}, {8.12, 3.17, 10.4, 16.8, 25.153152709359606}, {0.33, 11.57, 0.7, 0.22, -6.61969696969697});
    }

    @Test
    public void evaluateRegression() {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put(FIRST_NUMERIC_INPUT, this.firstNumericalInput);
        input.put(SECOND_NUMERIC_INPUT, this.secondNumericalInput);
        input.put(FIRST_CATEGORICAL_INPUT, "unused");
        input.put(SECOND_CATEGORICAL_INPUT, "unused");
        Object retrieved = this.regressionTable.evaluateRegression(input, (PMMLContext)Mockito.mock(PMMLContext.class));
        Assert.assertEquals((Object)this.expectedResult, (Object)retrieved);
    }

    private KiePMMLRegressionTable getKiePMMLRegressionTable() {
        HashMap<String, SerializableFunction<Double, Double>> numericFunctionMapLocal = new HashMap<String, SerializableFunction<Double, Double>>();
        numericFunctionMapLocal.put(FIRST_NUMERIC_INPUT, FIRST_NUMERIC_FUNCTION);
        numericFunctionMapLocal.put(SECOND_NUMERIC_INPUT, SECOND_NUMERIC_FUNCTION);
        HashMap<String, SerializableFunction<String, Double>> categoricalFunctionMapLocal = new HashMap<String, SerializableFunction<String, Double>>();
        categoricalFunctionMapLocal.put(FIRST_CATEGORICAL_INPUT, this.firstCategoricalFunction);
        categoricalFunctionMapLocal.put(SECOND_CATEGORICAL_INPUT, this.secondCategoricalFunction);
        return (KiePMMLRegressionTable)KiePMMLRegressionTable.builder((String)"", Collections.emptyList()).withTargetField(TARGET_FIELD).withNumericFunctionMap(numericFunctionMapLocal).withCategoricalFunctionMap(categoricalFunctionMapLocal).build();
    }
}

