/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.DoubleUnaryOperator;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.data.Offset;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.commons.testingutility.PMMLRuntimeContextTest;
import org.kie.pmml.models.regression.model.KiePMMLClassificationTable;
import org.kie.pmml.models.regression.model.KiePMMLRegressionTable;

public class KiePMMLClassificationTableTest {
    private static final DoubleUnaryOperator FIRST_ITEM_OPERATOR = aDouble -> 0.5 + 0.3183098861837907 * Math.atan(aDouble);
    private static final DoubleUnaryOperator SECOND_ITEM_OPERATOR = aDouble -> 1.0 - aDouble;
    private static final String CASE_A = "caseA";
    private static final String CASE_B = "caseB";
    private KiePMMLClassificationTable classificationTable;
    private double firstTableResult;
    private double secondTableResult;
    private String expectedResult;
    private double firstExpectedValue;
    private double secondExpectedValue;

    public void initKiePMMLClassificationTableTest(double firstTableResult, double secondTableResult, String expectedResult, double firstExpectedValue, double secondExpectedValue) {
        this.firstTableResult = firstTableResult;
        this.secondTableResult = secondTableResult;
        this.expectedResult = expectedResult;
        this.firstExpectedValue = firstExpectedValue;
        this.secondExpectedValue = secondExpectedValue;
        this.classificationTable = this.getKiePMMLRegressionClassificationTable();
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({24.5, 13.2, CASE_A, 0.5, 0.5}, {10.4, 16.8, CASE_A, 0.5, 0.5}, {-0.7, 123.22, CASE_A, 0.5, 0.5});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void evaluateRegression(double firstTableResult, double secondTableResult, String expectedResult, double firstExpectedValue, double secondExpectedValue) {
        this.initKiePMMLClassificationTableTest(firstTableResult, secondTableResult, expectedResult, firstExpectedValue, secondExpectedValue);
        PMMLRuntimeContextTest pmmlContextTest = new PMMLRuntimeContextTest();
        HashMap<String, Double> input = new HashMap<String, Double>();
        input.put(CASE_A, firstTableResult);
        input.put(CASE_B, secondTableResult);
        Object retrieved = this.classificationTable.evaluateRegression(input, (PMMLRuntimeContext)pmmlContextTest);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expectedResult);
        LinkedHashMap probabilityResultMap = pmmlContextTest.getProbabilityResultMap();
        Assertions.assertThat((Double)((Double)probabilityResultMap.get(CASE_A))).isCloseTo(firstExpectedValue, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)((Double)probabilityResultMap.get(CASE_B))).isCloseTo(secondExpectedValue, Offset.offset((Number)0.0));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void getProbabilityMap(double firstTableResult, double secondTableResult, String expectedResult, double firstExpectedValue, double secondExpectedValue) {
        this.initKiePMMLClassificationTableTest(firstTableResult, secondTableResult, expectedResult, firstExpectedValue, secondExpectedValue);
        LinkedHashMap<String, Double> resultMap = new LinkedHashMap<String, Double>();
        resultMap.put(CASE_B, firstTableResult);
        resultMap.put(CASE_A, secondTableResult);
        LinkedHashMap retrieved = KiePMMLClassificationTable.getProbabilityMap(resultMap, (DoubleUnaryOperator)FIRST_ITEM_OPERATOR, (DoubleUnaryOperator)SECOND_ITEM_OPERATOR);
        double expectedDouble = FIRST_ITEM_OPERATOR.applyAsDouble(firstTableResult);
        Assertions.assertThat((Double)((Double)retrieved.get(CASE_B))).isCloseTo(expectedDouble, Offset.offset((Number)0.0));
        expectedDouble = SECOND_ITEM_OPERATOR.applyAsDouble(expectedDouble);
        Assertions.assertThat((Double)((Double)retrieved.get(CASE_A))).isCloseTo(expectedDouble, Offset.offset((Number)0.0));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void getProbabilityMapFewInput(double firstTableResult, double secondTableResult, String expectedResult, double firstExpectedValue, double secondExpectedValue) {
        this.initKiePMMLClassificationTableTest(firstTableResult, secondTableResult, expectedResult, firstExpectedValue, secondExpectedValue);
        AssertionsForClassTypes.assertThatExceptionOfType(KiePMMLException.class).isThrownBy(() -> {
            LinkedHashMap<String, Double> resultMap = new LinkedHashMap<String, Double>();
            resultMap.put(CASE_B, firstTableResult);
            KiePMMLClassificationTable.getProbabilityMap(resultMap, (DoubleUnaryOperator)FIRST_ITEM_OPERATOR, (DoubleUnaryOperator)SECOND_ITEM_OPERATOR);
        });
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void getProbabilityMapTooManyInput(double firstTableResult, double secondTableResult, String expectedResult, double firstExpectedValue, double secondExpectedValue) {
        this.initKiePMMLClassificationTableTest(firstTableResult, secondTableResult, expectedResult, firstExpectedValue, secondExpectedValue);
        AssertionsForClassTypes.assertThatExceptionOfType(KiePMMLException.class).isThrownBy(() -> {
            LinkedHashMap<String, Double> resultMap = new LinkedHashMap<String, Double>();
            resultMap.put(CASE_B, firstTableResult);
            resultMap.put(CASE_A, secondTableResult);
            resultMap.put("CASE_ELSE", 444.1);
            KiePMMLClassificationTable.getProbabilityMap(resultMap, (DoubleUnaryOperator)FIRST_ITEM_OPERATOR, (DoubleUnaryOperator)SECOND_ITEM_OPERATOR);
        });
    }

    private KiePMMLClassificationTable getKiePMMLRegressionClassificationTable() {
        HashMap<String, KiePMMLRegressionTable> categoryTableMapLocal = new HashMap<String, KiePMMLRegressionTable>();
        categoryTableMapLocal.put(CASE_A, this.getKiePMMLRegressionTable());
        categoryTableMapLocal.put(CASE_B, this.getKiePMMLRegressionTable());
        return (KiePMMLClassificationTable)KiePMMLClassificationTable.builder((String)"", Collections.emptyList()).withCategoryTableMap(categoryTableMapLocal).withProbabilityMapFunction(KiePMMLClassificationTable::getCAUCHITProbabilityMap).build();
    }

    private KiePMMLRegressionTable getKiePMMLRegressionTable() {
        return (KiePMMLRegressionTable)KiePMMLRegressionTable.builder((String)"", Collections.emptyList()).build();
    }
}

