/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.pmml.api.iinterfaces.SerializableFunction;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.models.regression.model.KiePMMLRegressionTable;
import org.mockito.Mockito;

public class KiePMMLRegressionTableTest {
    private static final String TARGET_FIELD = "TARGET_FIELD";
    private static final String FIRST_NUMERIC_INPUT = "FIRST_NUMERIC_INPUT";
    private static final String SECOND_NUMERIC_INPUT = "SECOND_NUMERIC_INPUT";
    private static final String FIRST_CATEGORICAL_INPUT = "FIRST_CATEGORICAL_INPUT";
    private static final String SECOND_CATEGORICAL_INPUT = "SECOND_CATEGORICAL_INPUT";
    private static final SerializableFunction<Double, Double> FIRST_NUMERIC_FUNCTION = (SerializableFunction & Serializable)aDouble -> 1.0 / aDouble;
    private static final SerializableFunction<Double, Double> SECOND_NUMERIC_FUNCTION = (SerializableFunction & Serializable)aDouble -> 1.0 - aDouble;
    private KiePMMLRegressionTable regressionTable;
    private SerializableFunction<String, Double> firstCategoricalFunction;
    private SerializableFunction<String, Double> secondCategoricalFunction;
    private double firstNumericalInput;
    private double secondNumericalInput;
    private double expectedResult;

    public void initKiePMMLRegressionTableTest(double firstNumericalInput, double secondNumericalInput, double firstCategoricalResult, double secondCategoricalResult, double expectedResult) {
        this.firstCategoricalFunction = (SerializableFunction & Serializable)aObject -> firstCategoricalResult;
        this.secondCategoricalFunction = (SerializableFunction & Serializable)aObject -> secondCategoricalResult;
        this.firstNumericalInput = firstNumericalInput;
        this.secondNumericalInput = secondNumericalInput;
        this.expectedResult = expectedResult;
        this.regressionTable = this.getKiePMMLRegressionTable();
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({36.2, 11.2, 24.5, 13.2, 27.527624309392266}, {8.12, 3.17, 10.4, 16.8, 25.153152709359606}, {0.33, 11.57, 0.7, 0.22, -6.61969696969697});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void evaluateRegression(double firstNumericalInput, double secondNumericalInput, double firstCategoricalResult, double secondCategoricalResult, double expectedResult) {
        this.initKiePMMLRegressionTableTest(firstNumericalInput, secondNumericalInput, firstCategoricalResult, secondCategoricalResult, expectedResult);
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put(FIRST_NUMERIC_INPUT, firstNumericalInput);
        input.put(SECOND_NUMERIC_INPUT, secondNumericalInput);
        input.put(FIRST_CATEGORICAL_INPUT, "unused");
        input.put(SECOND_CATEGORICAL_INPUT, "unused");
        Object retrieved = this.regressionTable.evaluateRegression(input, (PMMLRuntimeContext)Mockito.mock(PMMLRuntimeContext.class));
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expectedResult);
    }

    private KiePMMLRegressionTable getKiePMMLRegressionTable() {
        HashMap<String, SerializableFunction<Double, Double>> numericFunctionMapLocal = new HashMap<String, SerializableFunction<Double, Double>>();
        numericFunctionMapLocal.put(FIRST_NUMERIC_INPUT, FIRST_NUMERIC_FUNCTION);
        numericFunctionMapLocal.put(SECOND_NUMERIC_INPUT, SECOND_NUMERIC_FUNCTION);
        HashMap<String, SerializableFunction<String, Double>> categoricalFunctionMapLocal = new HashMap<String, SerializableFunction<String, Double>>();
        categoricalFunctionMapLocal.put(FIRST_CATEGORICAL_INPUT, this.firstCategoricalFunction);
        categoricalFunctionMapLocal.put(SECOND_CATEGORICAL_INPUT, this.secondCategoricalFunction);
        return (KiePMMLRegressionTable)KiePMMLRegressionTable.builder((String)"", Collections.emptyList()).withTargetField(TARGET_FIELD).withNumericFunctionMap(numericFunctionMapLocal).withCategoricalFunctionMap(categoricalFunctionMapLocal).build();
    }
}

