/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.regression.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.regression.tests.AbstractPMMLRegressionTest;

@RunWith(value=Parameterized.class)
public class LinearRegressionSampleWithTransformationsTest
extends AbstractPMMLRegressionTest {
    private static final String MODEL_NAME = "LinearRegressionSampleWithTransformations";
    private static final String TARGET_FIELD = "number_of_claims";
    private static final String OUT_DER_AGE = "out_der_age";
    private static final String OUT_DER_SALARY = "out_der_salary";
    private static final String OUT_DER_CAR_LOCATION = "out_der_car_location";
    private static final String OUT_DER_CONSTANT = "out_der_constant";
    private static final String CONSTANT = "constant";
    private static final Percentage TOLERANCE_PERCENTAGE = Percentage.withPercentage((double)0.001);
    private static PMMLRuntime pmmlRuntime;
    private double age;
    private double salary;
    private String car_location;
    private double expectedResult;

    public LinearRegressionSampleWithTransformationsTest(double age, double salary, String car_location, double expectedResult) {
        this.age = age;
        this.salary = salary;
        this.car_location = car_location;
        this.expectedResult = expectedResult;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = LinearRegressionSampleWithTransformationsTest.getPMMLRuntime(MODEL_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({27, 34000, "street", 989.1}, {49, 78000, "carpark", 1301.37}, {57, 72000, "street", 1582.1}, {61, 123000, "carpark", 1836.5699999999997}, {18, 26000, "street", 845.1999999999999});
    }

    @Test
    public void testLogisticRegressionIrisData() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("age", this.age);
        inputData.put("salary", this.salary);
        inputData.put("car_location", this.car_location);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat((double)((Double)pmml4Result.getResultVariables().get(TARGET_FIELD))).isCloseTo(this.expectedResult, TOLERANCE_PERCENTAGE);
    }
}

