/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.regression.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.regression.tests.AbstractPMMLRegressionTest;

@RunWith(value=Parameterized.class)
public class LogisticRegressionTest
extends AbstractPMMLRegressionTest {
    private static final String MODEL_NAME = "LogisticRegression";
    private static final String TARGET_FIELD = "class";
    private static final String PROBABILITY_AUTHENTIC = "probability(Authentic)";
    private static final String PROBABILITY_COUNTERFEIT = "probability(Counterfeit)";
    private static final Percentage TOLERANCE_PERCENTAGE = Percentage.withPercentage((double)0.001);
    private static PMMLRuntime pmmlRuntime;
    private double variance;
    private double skewness;
    private double curtosis;
    private double entropy;
    private String expectedResult;
    private double expectedProbAuthentic;
    private double expectedProbCounterfeit;

    public LogisticRegressionTest(double variance, double skewness, double curtosis, double petalWidth, String expectedResult, double expectedProbAuthentic, double expectedProbCounterfeit) {
        this.variance = variance;
        this.skewness = skewness;
        this.curtosis = curtosis;
        this.entropy = petalWidth;
        this.expectedResult = expectedResult;
        this.expectedProbAuthentic = expectedProbAuthentic;
        this.expectedProbCounterfeit = expectedProbCounterfeit;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = LogisticRegressionTest.getPMMLRuntime(MODEL_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({2.3, 6.9, 3.1, 5.1, "Authentic", 0.9999999999999969, 3.1271452352700172E-15}, {1.2, 5.8, 2.6, 4.0, "Authentic", 0.9999999999977859, 2.214170674606705E-12}, {1.2, 5.7, 3.0, 4.2, "Authentic", 0.9999999999990105, 9.89558801361823E-13}, {0.2, 5.0, 3.3, 1.4, "Authentic", 0.9999999980426516, 1.9573484459863236E-9}, {0.4, 5.4, 3.9, 1.3, "Authentic", 0.9999999997410439, 2.589560996869738E-10});
    }

    @Test
    public void testLogisticRegressionIrisData() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("variance", this.variance);
        inputData.put("skewness", this.skewness);
        inputData.put("curtosis", this.curtosis);
        inputData.put("entropy", this.entropy);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.expectedResult);
    }
}

