/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.regression.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.regression.tests.AbstractPMMLRegressionTest;

@RunWith(value=Parameterized.class)
@Ignore(value="DROOLS-5209")
public class MissingDataRegressionTest
extends AbstractPMMLRegressionTest {
    private static final String MODEL_NAME = "MissingDataRegression";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private Double x;
    private String y;
    private double expectedResult;

    public MissingDataRegressionTest(Double x, String y, double expectedResult) {
        this.x = x;
        this.y = y;
        this.expectedResult = expectedResult;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = MissingDataRegressionTest.getPMMLRuntime(MODEL_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({0.0, "classA", 22}, {25.0, "classB", 92}, {25.0, null, 92}, {null, "classC", 72}, {null, null, 52});
    }

    @Test
    public void testMissingValuesRegression() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        if (this.x != null) {
            inputData.put("x", this.x);
        }
        if (this.y != null) {
            inputData.put("y", this.y);
        }
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat((Object)pmml4Result).isNotNull();
        Assertions.assertThat((Map)pmml4Result.getResultVariables()).containsKey((Object)TARGET_FIELD);
        Assertions.assertThat((Double)((Double)pmml4Result.getResultVariables().get(TARGET_FIELD))).isEqualTo(this.expectedResult);
    }
}

