/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.regression.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.regression.tests.AbstractPMMLRegressionTest;

@RunWith(value=Parameterized.class)
public class MixedVariablesRegressionTest
extends AbstractPMMLRegressionTest {
    private static final String MODEL_NAME = "MixedVariablesRegression";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private double x;
    private String y;

    public MixedVariablesRegressionTest(double x, String y) {
        this.x = x;
        this.y = y;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = MixedVariablesRegressionTest.getPMMLRuntime(MODEL_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({0, "classA"}, {-1, "classA"}, {0.5, "classA"}, {3, "classA"}, {25, "classB"}, {-100, "classB"}, {-100.1, "classB"}, {-8, "classC"}, {-1001.1, "classC"}, {-1701, "classC"});
    }

    private static double regressionFunction(double x, String y) {
        HashMap<String, Double> categoriesMap = new HashMap<String, Double>();
        categoriesMap.put("classA", 0.0);
        categoriesMap.put("classB", 20.0);
        categoriesMap.put("classC", 40.0);
        return 2.0 * x + (Double)categoriesMap.get(y) + 22.0;
    }

    @Test
    public void testMixedVariablesRegression() throws Exception {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("x", this.x);
        inputData.put("y", this.y);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat((Object)pmml4Result).isNotNull();
        Assertions.assertThat((Map)pmml4Result.getResultVariables()).containsKey((Object)TARGET_FIELD);
        Assertions.assertThat((Double)((Double)pmml4Result.getResultVariables().get(TARGET_FIELD))).isEqualTo(MixedVariablesRegressionTest.regressionFunction(this.x, this.y));
    }
}

