/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.regression.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class MultipleCategoricalVariablesRegressionTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "MultipleRegression.pmml";
    private static final String MODEL_NAME = "CategoricalVariablesRegression";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private String x;
    private String y;

    public MultipleCategoricalVariablesRegressionTest(String x, String y) {
        this.x = x;
        this.y = y;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = MultipleCategoricalVariablesRegressionTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"red", "classA"}, {"green", "classA"}, {"blue", "classA"}, {"orange", "classA"}, {"yellow", "classA"}, {"red", "classB"}, {"green", "classB"}, {"blue", "classB"}, {"orange", "classB"}, {"yellow", "classB"}, {"red", "classC"}, {"green", "classC"}, {"blue", "classC"}, {"orange", "classC"}, {"yellow", "classC"});
    }

    private static double regressionFunction(String x, String y) {
        HashMap<String, Double> categoriesMapX = new HashMap<String, Double>();
        categoriesMapX.put("red", 5.5);
        categoriesMapX.put("green", 15.0);
        categoriesMapX.put("blue", 12.0);
        categoriesMapX.put("orange", 5.5);
        categoriesMapX.put("yellow", -100.25);
        HashMap<String, Double> categoriesMapY = new HashMap<String, Double>();
        categoriesMapY.put("classA", 0.0);
        categoriesMapY.put("classB", 20.0);
        categoriesMapY.put("classC", 40.0);
        return (Double)categoriesMapX.get(x) + (Double)categoriesMapY.get(y) - 22.1;
    }

    @Test
    public void testCategoricalVariablesRegression() {
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("x", this.x);
        inputData.put("y", this.y);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat((Object)pmml4Result).isNotNull();
        Assertions.assertThat((Map)pmml4Result.getResultVariables()).containsKey((Object)TARGET_FIELD);
        Assertions.assertThat((Double)((Double)pmml4Result.getResultVariables().get(TARGET_FIELD))).isEqualTo(MultipleCategoricalVariablesRegressionTest.regressionFunction(this.x, this.y));
    }
}

