/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.regression.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class NumericVariablesLinearRegressionTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "NumericVariablesLinearRegression.pmml";
    private static final String MODEL_NAME = "NumericVariablesLinearRegression";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private double x;
    private double y;

    public NumericVariablesLinearRegressionTest(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = NumericVariablesLinearRegressionTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({0, 0}, {-1, 2}, {0.5, -2.5}, {3, 1}, {25, 50}, {-100, 250}, {-100.1, 800}, {-8, 12.5}, {-1001.1, -500.2}, {-1701, 508});
    }

    private static double regressionFunction(double x, double y) {
        return 2.0 * x + y + 5.0;
    }

    @Test
    public void testNumericVariableLinearRegression() throws Exception {
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("x", this.x);
        inputData.put("y", this.y);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat((Object)pmml4Result).isNotNull();
        Assertions.assertThat((Map)pmml4Result.getResultVariables()).containsKey((Object)TARGET_FIELD);
        Assertions.assertThat((Double)((Double)pmml4Result.getResultVariables().get(TARGET_FIELD))).isEqualTo(NumericVariablesLinearRegressionTest.regressionFunction(this.x, this.y));
    }
}

