/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.regression.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class MissingDataRegressionTest
extends AbstractPMMLTest {
    private static final String FILE_NAME_NO_SUFFIX = "MissingDataRegression";
    private static final String MODEL_NAME = "MissingDataRegression";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private Double x;
    private String y;
    private double expectedResult;

    public void initMissingDataRegressionTest(Double x, String y, double expectedResult) {
        this.x = x;
        this.y = y;
        this.expectedResult = expectedResult;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = MissingDataRegressionTest.getPMMLRuntime((String)"MissingDataRegression");
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({0.0, "classA", 22}, {25.0, "classB", 92}, {25.0, null, 92}, {null, "classC", 72}, {null, null, 52});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testMissingValuesRegression(Double x, String y, double expectedResult) {
        this.initMissingDataRegressionTest(x, y, expectedResult);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        if (x != null) {
            inputData.put("x", x);
        }
        if (y != null) {
            inputData.put("y", y);
        }
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, "MissingDataRegression", "MissingDataRegression");
        Assertions.assertThat((Object)pmml4Result).isNotNull();
        Assertions.assertThat((Map)pmml4Result.getResultVariables()).containsKey((Object)TARGET_FIELD);
        Assertions.assertThat((Double)((Double)pmml4Result.getResultVariables().get(TARGET_FIELD))).isEqualTo(expectedResult);
    }
}

