/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.regression.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class RegressionNormalizationExpTest
extends AbstractPMMLTest {
    private static final String FILE_NAME_NO_SUFFIX = "RegressionNormalizationExp";
    private static final String MODEL_NAME = "RegressionNormalizationExp";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private double x;
    private double y;

    public void initRegressionNormalizationExpTest(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = RegressionNormalizationExpTest.getPMMLRuntime((String)"RegressionNormalizationExp");
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({0, 0}, {-1, 2}, {0.5, -2.5}, {3, 1}, {25, 50}, {-100, 250}, {-100.1, 800}, {-8, 12.5}, {-1001.1, -500.2}, {-1701, 508});
    }

    private static double normalizedRegressionFunction(double x, double y) {
        double regressionValue = 2.0 * x + y + 5.0;
        return Math.exp(regressionValue);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testNormalizationMethodsRegression(double x, double y) throws Exception {
        this.initRegressionNormalizationExpTest(x, y);
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("x", x);
        inputData.put("y", y);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, "RegressionNormalizationExp", "RegressionNormalizationExp");
        Assertions.assertThat((Object)pmml4Result).isNotNull();
        Assertions.assertThat((Map)pmml4Result.getResultVariables()).containsKey((Object)TARGET_FIELD);
        Assertions.assertThat((Double)((Double)pmml4Result.getResultVariables().get(TARGET_FIELD))).isEqualTo(RegressionNormalizationExpTest.normalizedRegressionFunction(x, y));
    }
}

