/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.compiler.executor;

import java.io.Serializable;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.tree.TreeModel;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLModelWithSources;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.testutils.TestUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.models.tree.compiler.executor.TreeModelImplementationProvider;
import org.kie.pmml.models.tree.model.KiePMMLTreeModel;

public class TreeModelImplementationProviderTest {
    private static final TreeModelImplementationProvider PROVIDER = new TreeModelImplementationProvider();
    private static final String SOURCE_1 = "TreeSample.pmml";
    private static PMML pmml;

    @BeforeClass
    public static void setup() throws Exception {
        pmml = TestUtils.loadFromFile((String)SOURCE_1);
    }

    @Test
    public void getPMMLModelType() {
        Assertions.assertThat((Comparable)PROVIDER.getPMMLModelType()).isEqualTo((Object)PMML_MODEL.TREE_MODEL);
    }

    @Test
    public void getKiePMMLModel() {
        TreeModel treeModel = (TreeModel)pmml.getModels().get(0);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)treeModel, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLTreeModel retrieved = PROVIDER.getKiePMMLModel((CompilationDTO)compilationDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isInstanceOf(Serializable.class);
    }

    @Test
    public void getKiePMMLModelWithSources() {
        TreeModel treeModel = (TreeModel)pmml.getModels().get(0);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)treeModel, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLModelWithSources retrieved = PROVIDER.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Map sourcesMap = retrieved.getSourcesMap();
        Assertions.assertThat((Map)sourcesMap).isNotNull();
        Assertions.assertThat((Map)sourcesMap).isNotEmpty();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Map compiled = KieMemoryCompiler.compile((Map)sourcesMap, (ClassLoader)classLoader);
            for (Class clazz : compiled.values()) {
                Assertions.assertThat((Class)clazz).isInstanceOf(Serializable.class);
            }
        }
        catch (Throwable t) {
            Assertions.fail((String)t.getMessage());
        }
    }
}

