/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.compiler.executor;

import java.io.Serializable;
import java.util.Map;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLModelWithSources;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.testutils.TestUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.models.tree.compiler.executor.TreeModelImplementationProvider;
import org.kie.pmml.models.tree.model.KiePMMLTreeModel;

public class TreeModelImplementationProviderTest {
    private static final TreeModelImplementationProvider PROVIDER = new TreeModelImplementationProvider();
    private static final String SOURCE_1 = "TreeSample.pmml";
    private static PMML pmml;

    @BeforeClass
    public static void setup() throws Exception {
        pmml = TestUtils.loadFromFile((String)SOURCE_1);
    }

    @Test
    public void getPMMLModelType() {
        Assert.assertEquals((Object)PMML_MODEL.TREE_MODEL, (Object)PROVIDER.getPMMLModelType());
    }

    @Test
    public void getKiePMMLModel() {
        TreeModel treeModel = (TreeModel)pmml.getModels().get(0);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)treeModel, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLTreeModel retrieved = PROVIDER.getKiePMMLModel((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)(retrieved instanceof Serializable));
    }

    @Test
    public void getKiePMMLModelWithSources() {
        TreeModel treeModel = (TreeModel)pmml.getModels().get(0);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)treeModel, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLModelWithSources retrieved = PROVIDER.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        Map sourcesMap = retrieved.getSourcesMap();
        Assert.assertNotNull((Object)sourcesMap);
        Assert.assertFalse((boolean)sourcesMap.isEmpty());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Map compiled = KieMemoryCompiler.compile((Map)sourcesMap, (ClassLoader)classLoader);
            for (Class clazz : compiled.values()) {
                Assert.assertTrue((boolean)(clazz instanceof Serializable));
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }
}

