/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.api.testutils.TestUtils;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.tree.compiler.factories.KiePMMLNodeFactory;
import org.kie.pmml.models.tree.compiler.utils.KiePMMLTreeModelUtils;
import org.kie.pmml.models.tree.model.KiePMMLNode;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLNodeFactoryTest {
    private static final String SOURCE_1 = "TreeSample.pmml";
    private static final String SOURCE_2 = "TreeSimplified.pmml";
    private static final String TEST_01_SOURCE = "KiePMMLNodeFactoryTest_01.txt";
    private static PMML pmml1;
    private static Node node1;
    private static DataDictionary dataDictionary1;
    private static List<DerivedField> derivedFields1;
    private static PMML pmml2;
    private static Node nodeRoot;
    private static Node compoundPredicateNode;
    private static Node nodeLeaf;
    private static DataDictionary dataDictionary2;
    private static List<DerivedField> derivedFields2;

    @BeforeClass
    public static void setupClass() throws Exception {
        pmml1 = TestUtils.loadFromFile((String)SOURCE_1);
        TreeModel model1 = (TreeModel)pmml1.getModels().get(0);
        dataDictionary1 = pmml1.getDataDictionary();
        derivedFields1 = ModelUtils.getDerivedFields((TransformationDictionary)pmml1.getTransformationDictionary(), (LocalTransformations)model1.getLocalTransformations());
        node1 = model1.getNode();
        pmml2 = TestUtils.loadFromFile((String)SOURCE_2);
        TreeModel model2 = (TreeModel)pmml2.getModels().get(0);
        dataDictionary2 = pmml2.getDataDictionary();
        derivedFields2 = ModelUtils.getDerivedFields((TransformationDictionary)pmml2.getTransformationDictionary(), (LocalTransformations)model2.getLocalTransformations());
        nodeRoot = model2.getNode();
        compoundPredicateNode = (Node)nodeRoot.getNodes().get(0);
        nodeLeaf = (Node)((Node)((Node)nodeRoot.getNodes().get(0)).getNodes().get(0)).getNodes().get(0);
    }

    @Test
    public void getKiePMMLNode() {
        KiePMMLNode retrieved = KiePMMLNodeFactory.getKiePMMLNode((Node)node1, (List)CommonTestingUtils.getFieldsFromDataDictionaryAndDerivedFields((DataDictionary)dataDictionary1, derivedFields1), (String)"PACKAGE_NAME", (Double)1.0, (HasClassLoader)new HasClassLoaderMock());
        Assert.assertNotNull((Object)retrieved);
        this.commonVerifyNode(retrieved, node1);
    }

    @Test
    public void getKiePMMLNodeSourcesMap() {
        KiePMMLNodeFactory.NodeNamesDTO nodeNamesDTO = new KiePMMLNodeFactory.NodeNamesDTO(node1, KiePMMLTreeModelUtils.createNodeClassName(), null, Double.valueOf(1.0));
        Map retrieved = KiePMMLNodeFactory.getKiePMMLNodeSourcesMap((KiePMMLNodeFactory.NodeNamesDTO)nodeNamesDTO, (List)CommonTestingUtils.getFieldsFromDataDictionaryAndDerivedFields((DataDictionary)dataDictionary1, derivedFields1), (String)"PACKAGE_NAME");
        Assert.assertNotNull((Object)retrieved);
        this.commonVerifyNodeSource(retrieved, "PACKAGE_NAME");
    }

    @Test
    public void populateJavaParserDTOAndSourcesMap() {
        boolean isRoot = true;
        HashMap sourcesMap = new HashMap();
        KiePMMLNodeFactory.NodeNamesDTO nodeNamesDTO = new KiePMMLNodeFactory.NodeNamesDTO(nodeRoot, KiePMMLTreeModelUtils.createNodeClassName(), null, Double.valueOf(1.0));
        KiePMMLNodeFactory.JavaParserDTO toPopulate = new KiePMMLNodeFactory.JavaParserDTO(nodeNamesDTO, "PACKAGE_NAME");
        KiePMMLNodeFactory.populateJavaParserDTOAndSourcesMap((KiePMMLNodeFactory.JavaParserDTO)toPopulate, sourcesMap, (KiePMMLNodeFactory.NodeNamesDTO)nodeNamesDTO, (List)CommonTestingUtils.getFieldsFromDataDictionaryAndDerivedFields((DataDictionary)dataDictionary2, derivedFields2), (boolean)isRoot);
        this.commonVerifyEvaluateNode(toPopulate, nodeNamesDTO, isRoot);
    }

    @Test
    public void mergeNodeReferences() {
        KiePMMLNodeFactory.NodeNamesDTO nodeNamesDTO = new KiePMMLNodeFactory.NodeNamesDTO(nodeRoot, KiePMMLTreeModelUtils.createNodeClassName(), null, Double.valueOf(1.0));
        KiePMMLNodeFactory.JavaParserDTO toPopulate = new KiePMMLNodeFactory.JavaParserDTO(nodeNamesDTO, "PACKAGE_NAME");
        Node nestedNode = (Node)nodeRoot.getNodes().get(0);
        String nestedNodeClassName = (String)nodeNamesDTO.childrenNodes.get(nestedNode);
        String fullNestedNodeClassName = String.format("%s.%s", "PACKAGE_NAME", nestedNodeClassName);
        NodeList methodReferenceExprs = NodeList.nodeList((com.github.javaparser.ast.Node[])new Expression[]{KiePMMLNodeFactory.getEvaluateNodeMethodReference((String)fullNestedNodeClassName)});
        MethodReferenceExpr evaluateNodeReference = new MethodReferenceExpr();
        evaluateNodeReference.setScope((Expression)new NameExpr(fullNestedNodeClassName));
        evaluateNodeReference.setIdentifier("evaluateNode");
        MethodCallExpr evaluateNodeInitializer = new MethodCallExpr();
        evaluateNodeInitializer.setScope((Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)Arrays.class.getName())));
        evaluateNodeInitializer.setName("asList");
        evaluateNodeInitializer.setArguments(methodReferenceExprs);
        KiePMMLNodeFactory.NodeNamesDTO nestedNodeNamesDTO = new KiePMMLNodeFactory.NodeNamesDTO(nestedNode, nodeNamesDTO.getNestedNodeClassName(nestedNode), nodeNamesDTO.nodeClassName, nodeNamesDTO.missingValuePenalty);
        KiePMMLNodeFactory.mergeNodeReferences((KiePMMLNodeFactory.JavaParserDTO)toPopulate, (KiePMMLNodeFactory.NodeNamesDTO)nestedNodeNamesDTO, (MethodCallExpr)evaluateNodeInitializer);
        MethodReferenceExpr retrieved = ((Expression)evaluateNodeInitializer.getArguments().get(0)).asMethodReferenceExpr();
        String expected = toPopulate.nodeClassName;
        Assert.assertEquals((Object)expected, (Object)retrieved.getScope().asNameExpr().toString());
        expected = "evaluateNode" + nestedNodeClassName;
        Assert.assertEquals((Object)expected, (Object)retrieved.getIdentifier());
    }

    @Test
    public void populateEvaluateNode() {
        String packageName = "packageName";
        boolean isRoot = false;
        KiePMMLNodeFactory.NodeNamesDTO nodeNamesDTO = new KiePMMLNodeFactory.NodeNamesDTO(nodeLeaf, KiePMMLTreeModelUtils.createNodeClassName(), "PARENTNODECLASS", Double.valueOf(1.0));
        KiePMMLNodeFactory.JavaParserDTO toPopulate = new KiePMMLNodeFactory.JavaParserDTO(nodeNamesDTO, "packageName");
        KiePMMLNodeFactory.populateEvaluateNode((KiePMMLNodeFactory.JavaParserDTO)toPopulate, (KiePMMLNodeFactory.NodeNamesDTO)nodeNamesDTO, (List)CommonTestingUtils.getFieldsFromDataDictionaryAndDerivedFields((DataDictionary)dataDictionary2, derivedFields2), (boolean)isRoot);
        this.commonVerifyEvaluateNode(toPopulate, nodeNamesDTO, isRoot);
        isRoot = true;
        nodeNamesDTO = new KiePMMLNodeFactory.NodeNamesDTO(nodeRoot, KiePMMLTreeModelUtils.createNodeClassName(), null, Double.valueOf(1.0));
        toPopulate = new KiePMMLNodeFactory.JavaParserDTO(nodeNamesDTO, "packageName");
        KiePMMLNodeFactory.populateEvaluateNode((KiePMMLNodeFactory.JavaParserDTO)toPopulate, (KiePMMLNodeFactory.NodeNamesDTO)nodeNamesDTO, (List)CommonTestingUtils.getFieldsFromDataDictionaryAndDerivedFields((DataDictionary)dataDictionary2, derivedFields2), (boolean)isRoot);
        this.commonVerifyEvaluateNode(toPopulate, nodeNamesDTO, isRoot);
    }

    @Test
    public void populateEvaluateNodeWithNodeFunctions() {
        BlockStmt toPopulate = new BlockStmt();
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        variableDeclarator.setType("Object");
        variableDeclarator.setName("nodeFunctions");
        toPopulate.addStatement((Expression)new VariableDeclarationExpr(variableDeclarator));
        Assert.assertFalse((boolean)variableDeclarator.getInitializer().isPresent());
        List<String> nestedNodesFullClasses = Collections.emptyList();
        KiePMMLNodeFactory.populateEvaluateNodeWithNodeFunctions((BlockStmt)toPopulate, nestedNodesFullClasses);
        this.commonVerifyEvaluateNodeWithNodeFunctions(variableDeclarator, nestedNodesFullClasses);
        nestedNodesFullClasses = IntStream.range(0, 2).mapToObj(i -> "full.node.NodeClassName" + i).collect(Collectors.toList());
        KiePMMLNodeFactory.populateEvaluateNodeWithNodeFunctions((BlockStmt)toPopulate, nestedNodesFullClasses);
        this.commonVerifyEvaluateNodeWithNodeFunctions(variableDeclarator, nestedNodesFullClasses);
    }

    @Test
    public void getEvaluateNodeMethodReference() {
        String fullNodeClassName = "full.node.NodeClassName";
        MethodReferenceExpr retrieved = KiePMMLNodeFactory.getEvaluateNodeMethodReference((String)fullNodeClassName);
        Assert.assertEquals((Object)fullNodeClassName, (Object)retrieved.getScope().toString());
        Assert.assertEquals((Object)"evaluateNode", (Object)retrieved.getIdentifier());
    }

    @Test
    public void populateEvaluateNodeWithScore() {
        BlockStmt toPopulate = new BlockStmt();
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        variableDeclarator.setType("Object");
        variableDeclarator.setName("score");
        toPopulate.addStatement((Expression)new VariableDeclarationExpr(variableDeclarator));
        Assert.assertFalse((boolean)variableDeclarator.getInitializer().isPresent());
        Object score = null;
        KiePMMLNodeFactory.populateEvaluateNodeWithScore((BlockStmt)toPopulate, score);
        this.commonVerifyEvaluateNodeWithScore(variableDeclarator, score);
        score = "scoreValue";
        KiePMMLNodeFactory.populateEvaluateNodeWithScore((BlockStmt)toPopulate, (Object)score);
        this.commonVerifyEvaluateNodeWithScore(variableDeclarator, score);
        score = 54345.34;
        KiePMMLNodeFactory.populateEvaluateNodeWithScore((BlockStmt)toPopulate, (Object)score);
        this.commonVerifyEvaluateNodeWithScore(variableDeclarator, score);
    }

    @Test
    public void populateEvaluateNodeWithScoreDistributions() {
        BlockStmt toPopulate = new BlockStmt();
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        variableDeclarator.setType("List");
        variableDeclarator.setName("scoreDistributions");
        toPopulate.addStatement((Expression)new VariableDeclarationExpr(variableDeclarator));
        Assert.assertFalse((boolean)variableDeclarator.getInitializer().isPresent());
        List scoreDistributions = PMMLModelTestUtils.getRandomPMMLScoreDistributions((boolean)false);
        KiePMMLNodeFactory.populateEvaluateNodeWithScoreDistributions((BlockStmt)toPopulate, (List)scoreDistributions);
        this.commonVerifyEvaluateNodeWithScoreDistributions(variableDeclarator, scoreDistributions);
        scoreDistributions = PMMLModelTestUtils.getRandomPMMLScoreDistributions((boolean)true);
        KiePMMLNodeFactory.populateEvaluateNodeWithScoreDistributions((BlockStmt)toPopulate, (List)scoreDistributions);
        this.commonVerifyEvaluateNodeWithScoreDistributions(variableDeclarator, scoreDistributions);
    }

    @Test
    public void populateEvaluateNodeWithMissingValuePenalty() {
        BlockStmt toPopulate = new BlockStmt();
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        variableDeclarator.setType("double");
        variableDeclarator.setName("missingValuePenalty");
        toPopulate.addStatement((Expression)new VariableDeclarationExpr(variableDeclarator));
        Assert.assertFalse((boolean)variableDeclarator.getInitializer().isPresent());
        double missingValuePenalty = new Random().nextDouble();
        KiePMMLNodeFactory.populateEvaluateNodeWithMissingValuePenalty((BlockStmt)toPopulate, (Double)missingValuePenalty);
        Assert.assertTrue((boolean)variableDeclarator.getInitializer().isPresent());
        Expression expression = (Expression)variableDeclarator.getInitializer().get();
        Assert.assertTrue((boolean)(expression instanceof DoubleLiteralExpr));
        DoubleLiteralExpr doubleLiteralExpr = (DoubleLiteralExpr)expression;
        Assert.assertEquals((double)missingValuePenalty, (double)doubleLiteralExpr.asDouble(), (double)0.0);
    }

    @Test
    public void populateEvaluateNodeWithPredicateFunction() throws IOException {
        BlockStmt toPopulate = new BlockStmt();
        KiePMMLNodeFactory.populateEvaluateNodeWithPredicate((BlockStmt)toPopulate, (Predicate)compoundPredicateNode.getPredicate(), (List)CommonTestingUtils.getFieldsFromDataDictionaryAndDerivedFields((DataDictionary)dataDictionary2, derivedFields2));
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)text);
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((com.github.javaparser.ast.Node)expected, (com.github.javaparser.ast.Node)toPopulate));
    }

    @Test
    public void nodeNamesDTO() {
        KiePMMLNodeFactory.NodeNamesDTO retrieved = new KiePMMLNodeFactory.NodeNamesDTO(nodeRoot, KiePMMLTreeModelUtils.createNodeClassName(), "PACKAGE_NAME", Double.valueOf(1.0));
        Assert.assertEquals((long)nodeRoot.getNodes().size(), (long)retrieved.childrenNodes.size());
    }

    private void commonVerifyEvaluateNode(KiePMMLNodeFactory.JavaParserDTO toPopulate, KiePMMLNodeFactory.NodeNamesDTO nodeNamesDTO, boolean isRoot) {
        BlockStmt blockStmt = isRoot ? toPopulate.evaluateRootNodeBody : (BlockStmt)((MethodDeclaration)toPopulate.nodeTemplate.getMethodsByName("evaluateNode" + nodeNamesDTO.nodeClassName).get(0)).getBody().orElseThrow(() -> new RuntimeException("No body in nested node evaluate node"));
        VariableDeclarator variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)blockStmt, (String)"score").orElseThrow(() -> new RuntimeException("No SCORE variable declarator in generated methodCallExpr"));
        this.commonVerifyEvaluateNodeWithScore(variableDeclarator, nodeNamesDTO.node.getScore());
        variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)blockStmt, (String)"nodeFunctions").orElseThrow(() -> new RuntimeException("No NODE_FUNCTIONS variable declarator in generated methodCallExpr"));
        if (isRoot) {
            this.commonVerifyEvaluateNodeWithNodeFunctions(variableDeclarator, nodeNamesDTO.getNestedNodesFullClassNames(toPopulate.packageName));
        } else {
            this.commonVerifyEvaluateNodeWithNodeFunctions(variableDeclarator, new ArrayList<String>(nodeNamesDTO.childrenNodes.values()));
        }
    }

    private void commonVerifyEvaluateNodeWithNodeFunctions(VariableDeclarator variableDeclarator, List<String> nestedNodesFullClasses) {
        Assert.assertTrue((boolean)variableDeclarator.getInitializer().isPresent());
        Expression expression = (Expression)variableDeclarator.getInitializer().get();
        Assert.assertTrue((boolean)(expression instanceof MethodCallExpr));
        MethodCallExpr methodCallExpr = (MethodCallExpr)expression;
        Expression scope = (Expression)methodCallExpr.getScope().orElseThrow(() -> new RuntimeException("No scope in generated methodCallExpr"));
        if (nestedNodesFullClasses.isEmpty()) {
            Assert.assertEquals((Object)Collections.class.getName(), (Object)scope.toString());
            Assert.assertEquals((Object)"emptyList", (Object)methodCallExpr.getName().asString());
            Assert.assertTrue((boolean)methodCallExpr.getArguments().isEmpty());
        } else {
            Assert.assertEquals((Object)Arrays.class.getName(), (Object)scope.toString());
            Assert.assertEquals((Object)"asList", (Object)methodCallExpr.getName().asString());
            Assert.assertEquals((long)nestedNodesFullClasses.size(), (long)methodCallExpr.getArguments().size());
        }
    }

    private void commonVerifyEvaluateNodeWithScore(VariableDeclarator variableDeclarator, Object score) {
        Assert.assertTrue((boolean)variableDeclarator.getInitializer().isPresent());
        Expression expression = (Expression)variableDeclarator.getInitializer().get();
        if (score == null) {
            Assert.assertTrue((boolean)(expression instanceof NullLiteralExpr));
        } else {
            Assert.assertTrue((boolean)(expression instanceof NameExpr));
            String toFormat = score instanceof String ? "\"%s\"" : "%s";
            Assert.assertEquals((Object)String.format(toFormat, score), (Object)expression.toString());
        }
    }

    private void commonVerifyEvaluateNodeWithScoreDistributions(VariableDeclarator variableDeclarator, List<ScoreDistribution> scoreDistributions) {
        Assert.assertTrue((boolean)variableDeclarator.getInitializer().isPresent());
        Expression expression = (Expression)variableDeclarator.getInitializer().get();
        Assert.assertTrue((boolean)(expression instanceof MethodCallExpr));
        MethodCallExpr methodCallExpr = (MethodCallExpr)expression;
        Assert.assertEquals((Object)"Arrays", (Object)((Expression)methodCallExpr.getScope().get()).toString());
        Assert.assertEquals((Object)"asList", (Object)methodCallExpr.getName().toString());
        NodeList arguments = methodCallExpr.getArguments();
        Assert.assertEquals((long)scoreDistributions.size(), (long)arguments.size());
        arguments.forEach(argument -> Assert.assertTrue((boolean)(argument instanceof ObjectCreationExpr)));
        List objectCreationExprs = arguments.stream().map(ObjectCreationExpr.class::cast).collect(Collectors.toList());
        scoreDistributions.forEach(scoreDistribution -> {
            Optional<ObjectCreationExpr> retrieved = objectCreationExprs.stream().filter(objectCreationExpr -> scoreDistribution.getValue().equals(objectCreationExpr.getArgument(2).asStringLiteralExpr().asString())).findFirst();
            Assert.assertTrue((boolean)retrieved.isPresent());
            Expression recordCountExpected = CommonCodegenUtils.getExpressionForObject((Object)scoreDistribution.getRecordCount().intValue());
            Expression confidenceExpected = CommonCodegenUtils.getExpressionForObject((Object)scoreDistribution.getConfidence().doubleValue());
            NullLiteralExpr probabilityExpected = scoreDistribution.getProbability() != null ? CommonCodegenUtils.getExpressionForObject((Object)scoreDistribution.getProbability().doubleValue()) : new NullLiteralExpr();
            retrieved.ifPresent(arg_0 -> KiePMMLNodeFactoryTest.lambda$commonVerifyEvaluateNodeWithScoreDistributions$7(recordCountExpected, confidenceExpected, (Expression)probabilityExpected, arg_0));
        });
    }

    private void commonVerifyNode(KiePMMLNode toVerify, Node original) {
        Assert.assertEquals((Object)original.getId(), (Object)toVerify.getName());
    }

    private void commonVerifyNodeSource(Map<String, String> retrieved, String packageName) {
        Assert.assertEquals((long)1L, (long)retrieved.size());
        String toVerify = retrieved.values().iterator().next();
        CompilationUnit nodeCompilationUnit = JavaParserUtils.getFromSource((String)toVerify);
        Assert.assertEquals((Object)packageName, (Object)((PackageDeclaration)nodeCompilationUnit.getPackageDeclaration().get()).getName().asString());
    }

    private static /* synthetic */ void lambda$commonVerifyEvaluateNodeWithScoreDistributions$7(Expression recordCountExpected, Expression confidenceExpected, Expression probabilityExpected, ObjectCreationExpr objectCreationExpr) {
        Assert.assertEquals((Object)recordCountExpected, (Object)objectCreationExpr.getArgument(3));
        Assert.assertEquals((Object)confidenceExpected, (Object)objectCreationExpr.getArgument(4));
        Assert.assertEquals((Object)probabilityExpected, (Object)objectCreationExpr.getArgument(5));
    }
}

