/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Map;
import java.util.Optional;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.testutils.TestUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.tree.compiler.dto.TreeCompilationDTO;
import org.kie.pmml.models.tree.compiler.factories.KiePMMLTreeModelFactory;
import org.kie.pmml.models.tree.model.KiePMMLTreeModel;

public class KiePMMLTreeModelFactoryTest {
    private static final String SOURCE_1 = "TreeSample.pmml";
    private static final String SOURCE_2 = "TreeSimplified.pmml";
    private static PMML pmml1;
    private static DataDictionary dataDictionary1;
    private static TransformationDictionary transformationDictionary1;
    private static TreeModel treeModel1;
    private static PMML pmml2;
    private static DataDictionary dataDictionary2;
    private static TransformationDictionary transformationDictionary2;
    private static TreeModel treeModel2;

    @BeforeClass
    public static void setupClass() throws Exception {
        pmml1 = TestUtils.loadFromFile((String)SOURCE_1);
        dataDictionary1 = pmml1.getDataDictionary();
        transformationDictionary1 = pmml1.getTransformationDictionary();
        treeModel1 = (TreeModel)pmml1.getModels().get(0);
        pmml2 = TestUtils.loadFromFile((String)SOURCE_2);
        dataDictionary2 = pmml2.getDataDictionary();
        transformationDictionary2 = pmml2.getTransformationDictionary();
        treeModel2 = (TreeModel)pmml2.getModels().get(0);
    }

    @Test
    public void getKiePMMLTreeModel() {
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml1, (Model)treeModel1, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLTreeModel retrieved = KiePMMLTreeModelFactory.getKiePMMLTreeModel((TreeCompilationDTO)TreeCompilationDTO.fromCompilationDTO((CompilationDTO)source));
        Assert.assertNotNull((Object)retrieved);
        source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml2, (Model)treeModel2, (HasClassLoader)new HasClassLoaderMock());
        retrieved = KiePMMLTreeModelFactory.getKiePMMLTreeModel((TreeCompilationDTO)TreeCompilationDTO.fromCompilationDTO((CompilationDTO)source));
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void getKiePMMLTreeModelSourcesMap() {
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml1, (Model)treeModel1, (HasClassLoader)new HasClassLoaderMock());
        Map retrieved = KiePMMLTreeModelFactory.getKiePMMLTreeModelSourcesMap((TreeCompilationDTO)TreeCompilationDTO.fromCompilationDTO((CompilationDTO)source));
        Assert.assertNotNull((Object)retrieved);
        source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml2, (Model)treeModel2, (HasClassLoader)new HasClassLoaderMock());
        retrieved = KiePMMLTreeModelFactory.getKiePMMLTreeModelSourcesMap((TreeCompilationDTO)TreeCompilationDTO.fromCompilationDTO((CompilationDTO)source));
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void setConstructor() {
        String className = KiePMMLModelUtils.getSanitizedClassName((String)treeModel1.getModelName());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)"PACKAGE_NAME", (String)"KiePMMLTreeModelTemplate.tmpl", (String)"KiePMMLTreeModelTemplate");
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        String targetField = "whatIdo";
        String fullNodeClassName = "full.Node.ClassName";
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml1, (Model)treeModel1, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLTreeModelFactory.setConstructor((TreeCompilationDTO)TreeCompilationDTO.fromCompilationDTO((CompilationDTO)source), (ClassOrInterfaceDeclaration)modelTemplate, (String)fullNodeClassName);
        ConstructorDeclaration constructorDeclaration = ((ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())))).clone();
        BlockStmt body = constructorDeclaration.getBody();
        Optional optRetrieved = CommonCodegenUtils.getAssignExpression((BlockStmt)body, (String)"targetField");
        Assert.assertTrue((boolean)optRetrieved.isPresent());
        AssignExpr retrieved = (AssignExpr)optRetrieved.get();
        Expression initializer = retrieved.getValue();
        Assert.assertTrue((boolean)(initializer instanceof StringLiteralExpr));
        String expected = String.format("\"%s\"", targetField);
        Assert.assertEquals((Object)expected, (Object)initializer.toString());
        optRetrieved = CommonCodegenUtils.getAssignExpression((BlockStmt)body, (String)"miningFunction");
        Assert.assertTrue((boolean)optRetrieved.isPresent());
        retrieved = (AssignExpr)optRetrieved.get();
        initializer = retrieved.getValue();
        Assert.assertTrue((boolean)(initializer instanceof NameExpr));
        MINING_FUNCTION miningFunction = MINING_FUNCTION.byName((String)treeModel1.getMiningFunction().value());
        expected = miningFunction.getClass().getName() + "." + miningFunction.name();
        Assert.assertEquals((Object)expected, (Object)initializer.toString());
        optRetrieved = CommonCodegenUtils.getAssignExpression((BlockStmt)body, (String)"pmmlMODEL");
        Assert.assertTrue((boolean)optRetrieved.isPresent());
        retrieved = (AssignExpr)optRetrieved.get();
        initializer = retrieved.getValue();
        Assert.assertTrue((boolean)(initializer instanceof NameExpr));
        expected = PMML_MODEL.TREE_MODEL.getClass().getName() + "." + PMML_MODEL.TREE_MODEL.name();
        Assert.assertEquals((Object)expected, (Object)initializer.toString());
        optRetrieved = CommonCodegenUtils.getAssignExpression((BlockStmt)body, (String)"nodeFunction");
        Assert.assertTrue((boolean)optRetrieved.isPresent());
        retrieved = (AssignExpr)optRetrieved.get();
        initializer = retrieved.getValue();
        Assert.assertTrue((boolean)(initializer instanceof MethodReferenceExpr));
        expected = fullNodeClassName;
        Assert.assertEquals((Object)expected, (Object)((MethodReferenceExpr)initializer).getScope().toString());
        expected = "evaluateNode";
        Assert.assertEquals((Object)expected, (Object)((MethodReferenceExpr)initializer).getIdentifier());
    }
}

