/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.command;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.remote.command.DeleteCommand;
import org.kie.remote.command.EventInsertCommand;
import org.kie.remote.command.FactCountCommand;
import org.kie.remote.command.FireAllRulesCommand;
import org.kie.remote.command.FireUntilHaltCommand;
import org.kie.remote.command.HaltCommand;
import org.kie.remote.command.InsertCommand;
import org.kie.remote.command.ListObjectsCommand;
import org.kie.remote.command.ListObjectsCommandClassType;
import org.kie.remote.command.ListObjectsCommandNamedQuery;
import org.kie.remote.command.RemoteCommand;
import org.kie.remote.command.SnapshotOnDemandCommand;
import org.kie.remote.command.UpdateCommand;

public class RemoteCommandsTest {
    @Test
    public void testIsPermittedForReplicas() {
        List permittedForReplicas = RemoteCommandsTest.allRemoteCommands().stream().filter(c -> c.isPermittedForReplicas()).collect(Collectors.toList());
        Assertions.assertThat(permittedForReplicas).extracting("class").contains(new Object[]{DeleteCommand.class});
        Assertions.assertThat(permittedForReplicas).extracting("class").contains(new Object[]{EventInsertCommand.class});
        Assertions.assertThat(permittedForReplicas).extracting("class").contains(new Object[]{FireAllRulesCommand.class});
        Assertions.assertThat(permittedForReplicas).extracting("class").contains(new Object[]{FireUntilHaltCommand.class});
        Assertions.assertThat(permittedForReplicas).extracting("class").contains(new Object[]{HaltCommand.class});
        Assertions.assertThat(permittedForReplicas).extracting("class").contains(new Object[]{InsertCommand.class});
    }

    @Test
    public void testIsForbiddenForReplicas() {
        List forbiddenForReplicas = RemoteCommandsTest.allRemoteCommands().stream().filter(c -> !c.isPermittedForReplicas()).collect(Collectors.toList());
        Assertions.assertThat(forbiddenForReplicas).extracting("class").contains(new Object[]{FactCountCommand.class});
        Assertions.assertThat(forbiddenForReplicas).extracting("class").contains(new Object[]{ListObjectsCommand.class});
        Assertions.assertThat(forbiddenForReplicas).extracting("class").contains(new Object[]{ListObjectsCommandClassType.class});
        Assertions.assertThat(forbiddenForReplicas).extracting("class").contains(new Object[]{ListObjectsCommandNamedQuery.class});
    }

    private static List<RemoteCommand> allRemoteCommands() {
        ArrayList<RemoteCommand> commands = new ArrayList<RemoteCommand>();
        commands.add((RemoteCommand)new DeleteCommand());
        commands.add((RemoteCommand)new EventInsertCommand());
        commands.add((RemoteCommand)new FactCountCommand());
        commands.add((RemoteCommand)new FactCountCommand());
        commands.add((RemoteCommand)new FireAllRulesCommand());
        commands.add((RemoteCommand)new FireUntilHaltCommand());
        commands.add((RemoteCommand)new HaltCommand());
        commands.add((RemoteCommand)new InsertCommand());
        commands.add((RemoteCommand)new ListObjectsCommand());
        commands.add((RemoteCommand)new ListObjectsCommandClassType());
        commands.add((RemoteCommand)new ListObjectsCommandNamedQuery());
        commands.add((RemoteCommand)new UpdateCommand());
        commands.add((RemoteCommand)new SnapshotOnDemandCommand());
        return commands;
    }
}

