/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConfig {
    private static final Logger logger = LoggerFactory.getLogger(CommonConfig.class);
    public static final String DEFAULT_NAMESPACE = "default";
    public static final String DEFAULT_EVENTS_TOPIC = "events";
    public static final String DEFAULT_KIE_SESSION_INFOS_TOPIC = "kiesessioninfos";
    public static final int DEFAULT_POLL_TIMEOUT_MS = 1000;
    public static final String KEY_SERIALIZER_KEY = "key.serializer";
    public static final String VALUE_SERIALIZER_KEY = "value.serializer";
    public static final String KEY_DESERIALIZER_KEY = "key.deserializer";
    public static final String VALUE_DESERIALIZER_KEY = "value.deserializer";
    private static Properties producerConf;
    private static final String PRODUCER_CONF = "producer.properties";
    public static final String LOCAL_MESSAGE_SYSTEM_CONF = "local.message.system";
    public static final String SKIP_LISTENER_AUTOSTART = "skip.listener.autostart";
    private static Properties config;

    public static synchronized Properties getStatic() {
        if (config == null) {
            config = new Properties();
            config.put(KEY_SERIALIZER_KEY, "org.apache.kafka.common.serialization.StringSerializer");
            config.put(VALUE_SERIALIZER_KEY, "org.apache.kafka.common.serialization.ByteArraySerializer");
            config.put(KEY_DESERIALIZER_KEY, "org.apache.kafka.common.serialization.StringDeserializer");
            config.put(VALUE_DESERIALIZER_KEY, "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            config.put("group.id", "drools");
        }
        return config;
    }

    public static Properties getTestProperties() {
        Properties props = new Properties();
        props.put(LOCAL_MESSAGE_SYSTEM_CONF, (Object)true);
        return props;
    }

    public static Properties getProducerConfig(String caller) {
        if (producerConf == null) {
            producerConf = CommonConfig.getDefaultConfigFromProps(PRODUCER_CONF);
        }
        CommonConfig.logConfig(caller, producerConf);
        return producerConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getDefaultConfigFromProps(String fileName) {
        Properties config = new Properties();
        InputStream in = null;
        try {
            in = CommonConfig.class.getClassLoader().getResourceAsStream(fileName);
        }
        catch (Exception ioe) {
        }
        finally {
            try {
                config.load(in);
                in.close();
            }
            catch (IOException ioe) {
                logger.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
        return config;
    }

    private static void logConfig(String subject, Properties producerProperties) {
        if (logger.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append(subject);
            sb.append("\n{\n");
            for (Map.Entry<Object, Object> entry : producerProperties.entrySet()) {
                sb.append(" ").append(entry.getKey().toString()).append(":").append(entry.getValue()).append("  \n");
            }
            sb.append("\n}\n");
            logger.info(sb.toString());
        }
    }
}

