/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Supplier;

public abstract class DroolsExecutor {
    private static boolean isLeader = false;
    protected Queue<Object> executionResults = new ArrayDeque<Object>();

    public static DroolsExecutor getInstance() {
        return isLeader ? Leader.INSTANCE : Slave.INSTANCE;
    }

    public static void setAsLeader() {
        isLeader = true;
    }

    public static void setAsReplica() {
        isLeader = false;
    }

    public abstract boolean isLeader();

    public abstract void execute(Runnable var1);

    public abstract <R> R execute(Supplier<R> var1);

    public Queue<Object> getAndReset() {
        throw new UnsupportedOperationException();
    }

    public void appendSideEffects(Queue<Object> sideEffects) {
        throw new UnsupportedOperationException();
    }

    public static class EmptyResult
    implements Serializable {
        public static final EmptyResult INSTANCE = new EmptyResult();
    }

    public static class Slave
    extends DroolsExecutor {
        private static final Slave INSTANCE = new Slave();

        @Override
        public boolean isLeader() {
            return false;
        }

        @Override
        public void execute(Runnable f) {
            this.executionResults.poll();
        }

        @Override
        public <R> R execute(Supplier<R> f) {
            return (R)this.executionResults.poll();
        }

        @Override
        public void appendSideEffects(Queue<Object> sideEffects) {
            this.executionResults.addAll(sideEffects);
        }
    }

    public static class Leader
    extends DroolsExecutor {
        private static final Leader INSTANCE = new Leader();

        @Override
        public boolean isLeader() {
            return true;
        }

        @Override
        public void execute(Runnable f) {
            f.run();
            this.executionResults.add(EmptyResult.INSTANCE);
        }

        @Override
        public <R> R execute(Supplier<R> f) {
            R result = f.get();
            this.executionResults.add(result);
            return result;
        }

        @Override
        public Queue<Object> getAndReset() {
            Queue results = this.executionResults;
            this.executionResults = new ArrayDeque();
            return results;
        }
    }
}

