/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.command;

import java.io.Serializable;
import java.util.UUID;
import org.kie.remote.command.AbstractCommand;
import org.kie.remote.command.RemoteCommand;
import org.kie.remote.command.VisitableCommand;
import org.kie.remote.command.VisitorCommand;

public class UpdateKJarCommand
extends AbstractCommand
implements VisitableCommand,
RemoteCommand,
Serializable {
    private String kJarGAV;
    private String groupID;
    private String artifactID;
    private String version;

    public UpdateKJarCommand(String kjarGAV) {
        super(UUID.randomUUID().toString());
        this.kJarGAV = kjarGAV;
        String[] parts = this.kJarGAV.split(":");
        this.groupID = parts[0];
        this.artifactID = parts[1];
        this.version = parts[2];
    }

    public String getKJarGAV() {
        return this.kJarGAV;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public String getArtifactID() {
        return this.artifactID;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public void accept(VisitorCommand visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isPermittedForReplicas() {
        return true;
    }

    public String toString() {
        return "UpdateKJarCommand with KJar GAV:" + this.kJarGAV;
    }
}

