/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConfig {
    public static final String DEFAULT_NAMESPACE = "default";
    public static final String DEFAULT_EVENTS_TOPIC = "events";
    public static final String DEFAULT_KIE_SESSION_INFOS_TOPIC = "kiesessioninfos";
    public static final int DEFAULT_POLL_TIMEOUT_MS = 1000;
    public static final String KEY_SERIALIZER_KEY = "key.serializer";
    public static final String VALUE_SERIALIZER_KEY = "value.serializer";
    public static final String KEY_DESERIALIZER_KEY = "key.deserializer";
    public static final String VALUE_DESERIALIZER_KEY = "value.deserializer";
    public static final String GROUP_ID_CONFIG = "group.id";
    public static final String LOCAL_MESSAGE_SYSTEM_CONF = "local.message.system";
    public static final String SKIP_LISTENER_AUTOSTART = "skip.listener.autostart";
    private static final Logger logger = LoggerFactory.getLogger(CommonConfig.class);
    private static final String PRODUCER_CONF = "producer.properties";
    private static Properties producerConf;
    private static Properties config;

    private CommonConfig() {
    }

    public static synchronized Properties getStatic() {
        if (config == null) {
            config = new Properties();
            config.put(KEY_SERIALIZER_KEY, "org.apache.kafka.common.serialization.StringSerializer");
            config.put(VALUE_SERIALIZER_KEY, "org.apache.kafka.common.serialization.ByteArraySerializer");
            config.put(KEY_DESERIALIZER_KEY, "org.apache.kafka.common.serialization.StringDeserializer");
            config.put(VALUE_DESERIALIZER_KEY, "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            config.put(GROUP_ID_CONFIG, "drools");
        }
        return config;
    }

    public static Properties getTestProperties() {
        Properties props = new Properties();
        props.put(LOCAL_MESSAGE_SYSTEM_CONF, (Object)true);
        return props;
    }

    public static Properties getProducerConfig() {
        if (producerConf == null) {
            producerConf = CommonConfig.getDefaultConfigFromProps(PRODUCER_CONF);
        }
        return producerConf;
    }

    public static Properties getDefaultConfigFromProps(String fileName) {
        Properties config = new Properties();
        try (InputStream in = CommonConfig.class.getClassLoader().getResourceAsStream(fileName);){
            config.load(in);
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
        }
        return config;
    }
}

