/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.ReleaseId;

@Path(value="/server")
public interface KieServer {
    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getInfo();

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response execute(CommandScript var1);

    @GET
    @Path(value="containers")
    @Produces(value={"application/xml", "application/json"})
    public Response listContainers();

    @GET
    @Path(value="containers/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response getContainerInfo(@PathParam(value="id") String var1);

    @PUT
    @Path(value="containers/{id}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createContainer(@PathParam(value="id") String var1, KieContainerResource var2);

    @DELETE
    @Path(value="containers/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response disposeContainer(@PathParam(value="id") String var1);

    @POST
    @Path(value="containers/{id}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response execute(@PathParam(value="id") String var1, String var2);

    @GET
    @Path(value="containers/{id}/release-id")
    @Produces(value={"application/xml", "application/json"})
    public Response getReleaseId(@PathParam(value="id") String var1);

    @POST
    @Path(value="containers/{id}/release-id")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateReleaseId(@PathParam(value="id") String var1, ReleaseId var2);

    @GET
    @Path(value="containers/{id}/scanner")
    @Produces(value={"application/xml", "application/json"})
    public Response getScannerInfo(@PathParam(value="id") String var1);

    @POST
    @Path(value="containers/{id}/scanner")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateScanner(@PathParam(value="id") String var1, KieScannerResource var2);
}

