/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.samples;

import java.io.File;
import java.util.HashMap;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.AFReleaseId;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.admin.MigrationReportInstance;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.admin.ProcessAdminServicesClient;
import org.kie.server.springboot.samples.KieServerApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={KieServerApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-test.properties"})
public class KieServerMigrationTest {
    static final String ARTIFACT_ID = "evaluation";
    static final String GROUP_ID = "org.jbpm.test";
    static final String VERSION = "1.0.0";
    @LocalServerPort
    private int port;
    private String user = "john";
    private String password = "john@pwd1";
    private String containerAlias = "eval";
    private String containerId = "evaluation";
    private String containerId2 = "evaluation2";
    private String processId = "evaluation";
    private KieServicesClient kieServicesClient;

    @BeforeClass
    public static void generalSetup() {
        System.setProperty("org.kie.server.mode", KieServerMode.PRODUCTION.name());
        KieServices ks = KieServices.Factory.get();
        org.kie.api.builder.ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        File kjar = new File("../kjars/evaluation/jbpm-module.jar");
        File pom = new File("../kjars/evaluation/pom.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kjar, pom);
    }

    @AfterClass
    public static void generalCleanup() {
        System.clearProperty("org.kie.server.mode");
    }

    @Before
    public void setup() {
        ReleaseId releaseId = new ReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        String serverUrl = "http://localhost:" + this.port + "/rest/server";
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)serverUrl, (String)this.user, (String)this.password);
        configuration.setTimeout(60000L);
        configuration.setMarshallingFormat(MarshallingFormat.JSON);
        this.kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
        KieContainerResource resource = new KieContainerResource(this.containerId, releaseId);
        resource.setContainerAlias(this.containerAlias);
        KieServerConfigItem configItem = new KieServerConfigItem();
        configItem.setName("RuntimeStrategy");
        configItem.setValue("PER_PROCESS_INSTANCE");
        configItem.setType("BPM");
        resource.addConfigItem(configItem);
        this.kieServicesClient.createContainer(this.containerId, resource);
        KieContainerResource resource2 = new KieContainerResource(this.containerId2, releaseId);
        resource2.setContainerAlias(this.containerAlias);
        resource2.addConfigItem(configItem);
        this.kieServicesClient.createContainer(this.containerId2, resource2);
    }

    @After
    public void cleanup() {
        this.kieServicesClient.disposeContainer(this.containerId);
        this.kieServicesClient.disposeContainer(this.containerId2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessStartAndAbort() {
        QueryServicesClient queryClient = (QueryServicesClient)this.kieServicesClient.getServicesClient(QueryServicesClient.class);
        ProcessServicesClient processClient = (ProcessServicesClient)this.kieServicesClient.getServicesClient(ProcessServicesClient.class);
        ProcessAdminServicesClient processAdminClient = (ProcessAdminServicesClient)this.kieServicesClient.getServicesClient(ProcessAdminServicesClient.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john");
        params.put("reason", "test on spring boot");
        Long processInstanceId = processClient.startProcess(this.containerId, this.processId, params);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance processInstance = queryClient.findProcessInstanceById(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)1L, (long)processInstance.getState().intValue());
        Assert.assertEquals((Object)this.containerId, (Object)processInstance.getContainerId());
        try {
            MigrationReportInstance report = processAdminClient.migrateProcessInstance(this.containerId, processInstanceId, this.containerId2, this.processId);
            Assert.assertTrue((boolean)report.isSuccessful());
            processInstance = queryClient.findProcessInstanceById(processInstanceId);
            Assert.assertNotNull((Object)processInstance);
            Assert.assertEquals((long)1L, (long)processInstance.getState().intValue());
            Assert.assertEquals((Object)this.containerId2, (Object)processInstance.getContainerId());
        }
        finally {
            processClient.abortProcessInstance(this.containerId2, processInstanceId);
            processInstance = queryClient.findProcessInstanceById(processInstanceId);
            Assert.assertNotNull((Object)processInstance);
            Assert.assertEquals((long)3L, (long)processInstance.getState().intValue());
        }
    }
}

