/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.samples;

import java.util.ArrayList;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.io.impl.ClassPathResource;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.io.Resource;
import org.kie.api.runtime.ExecutionResults;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.RuleServicesClient;
import org.kie.server.springboot.samples.KieServerApplication;
import org.kie.server.springboot.samples.listeners.SampleAgendaEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={KieServerApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-rules.properties"})
public class RulesOnlyKieServerTest {
    static final String ARTIFACT_ID = "rules";
    static final String GROUP_ID = "org.jbpm.test";
    static final String VERSION = "1.0.0";
    @LocalServerPort
    private int port;
    private String user = "john";
    private String password = "john@pwd1";
    private String containerId = "rules";
    private KieServicesClient kieServicesClient;
    @Autowired
    private SampleAgendaEventListener listener;

    @BeforeClass
    public static void generalSetup() {
        System.setProperty("org.kie.server.mode", KieServerMode.PRODUCTION.name());
        RulesOnlyKieServerTest.createKJar();
    }

    @AfterClass
    public static void generalCleanup() {
        System.clearProperty("org.kie.server.mode");
    }

    @Before
    public void setup() {
        this.listener.clear();
        ReleaseId releaseId = new ReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        String serverUrl = "http://localhost:" + this.port + "/rest/server";
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)serverUrl, (String)this.user, (String)this.password);
        configuration.setTimeout(60000L);
        configuration.setMarshallingFormat(MarshallingFormat.JSON);
        this.kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
        KieContainerResource resource = new KieContainerResource(this.containerId, releaseId);
        this.kieServicesClient.createContainer(this.containerId, resource);
    }

    @After
    public void cleanup() {
        this.kieServicesClient.disposeContainer(this.containerId);
    }

    @Test
    public void testInvokeRulesOnStateless() {
        this.testInvokeRulesOn("defaultStatelessKieSession");
    }

    @Test
    public void testInvokeRulesOnStatefull() {
        this.testInvokeRulesOn("defaultKieSession");
    }

    private void testInvokeRulesOn(String ksessionName) {
        ArrayList<Command> commands = new ArrayList<Command>();
        KieCommands cmdFactory = KieServices.Factory.get().getCommands();
        commands.add(cmdFactory.newInsert((Object)"John"));
        commands.add(cmdFactory.newFireAllRules("fire-identifier"));
        RuleServicesClient rulesClient = (RuleServicesClient)this.kieServicesClient.getServicesClient(RuleServicesClient.class);
        ServiceResponse reply = rulesClient.executeCommandsWithResults(ARTIFACT_ID, (Command)cmdFactory.newBatchExecution(commands, ksessionName));
        if (!KieServiceResponse.ResponseType.SUCCESS.equals((Object)reply.getType())) {
            throw new RuntimeException("executeRule failed with message: " + reply.getMsg());
        }
        ExecutionResults result = (ExecutionResults)reply.getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)this.listener.getFired().size());
        Assert.assertEquals((Object)"Your First Rule", (Object)this.listener.getFired().get(0));
    }

    private static void createKJar() {
        KieServices kieServices = KieServices.get();
        org.kie.api.builder.ReleaseId releaseId = kieServices.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        KieFileSystem kfs = kieServices.newKieFileSystem();
        kfs.generateAndWritePomXML(releaseId);
        byte[] pom = kfs.read("pom.xml");
        kfs.write("src/main/resources/sample-rule.drl", (Resource)new ClassPathResource("sample-rules.drl"));
        KieBuilder kb = kieServices.newKieBuilder(kfs).buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            for (Message result : kb.getResults().getMessages()) {
                System.out.println("Error: " + result.getText());
            }
            throw new RuntimeException("Unable to create KJar for requested conditions resources");
        }
        InternalKieModule kieModule = (InternalKieModule)kieServices.getRepository().getKieModule(releaseId);
        byte[] kjar = kieModule.getBytes();
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kjar, pom);
    }
}

