/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.samples.rest;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.common.rest.KieServerHttpRequest;
import org.kie.server.common.rest.KieServerHttpResponse;
import org.kie.server.springboot.samples.KieServerApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={KieServerApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-jaxrstest.properties"})
public class KieServerWithExtraEndpointTest {
    @LocalServerPort
    private int port;
    private String user = "john";
    private String password = "john@pwd1";

    @Test
    public void testExtraEndpoint() {
        String extraEndpoint = "http://localhost:" + this.port + "/rest/extra";
        KieServerHttpRequest httpRequest = KieServerHttpRequest.newRequest((String)extraEndpoint, (String)this.user, (String)this.password).followRedirects(true).timeout(1000L).contentType("application/json").accept("application/json");
        httpRequest.get();
        KieServerHttpResponse response = httpRequest.response();
        int responseCode = response.code();
        Assert.assertEquals((long)200L, (long)responseCode);
    }
}

