/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.Collection;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.spring.jbpm.AbstractJbpmSpringTest;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@RunWith(value=Parameterized.class)
public class AuditLogSpringTest
extends AbstractJbpmSpringTest {
    @Parameterized.Parameter(value=0)
    public String contextPath;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{"jbpm/jta-em/singleton.xml"}, {"jbpm/local-em/singleton.xml"}};
        return Arrays.asList(data);
    }

    @Test
    public void testAuditLog() throws Exception {
        this.context = new ClassPathXmlApplicationContext(this.contextPath);
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        AuditLogService auditLogService = (AuditLogService)this.context.getBean("logService");
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = engine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        ProcessInstanceLog instanceLog = auditLogService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)1L, (long)instanceLog.getStatus().intValue());
        ksession.abortProcessInstance(processInstance.getId());
        instanceLog = auditLogService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)3L, (long)instanceLog.getStatus().intValue());
        manager.disposeRuntimeEngine(engine);
    }
}

