/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.List;
import javax.persistence.EntityManager;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.spring.jbpm.AbstractJbpmSpringTest;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PerProcessInstanceSpringTest
extends AbstractJbpmSpringTest {
    @Test
    public void testNoSessionInDbAfterInit() throws Exception {
        this.context = new ClassPathXmlApplicationContext("jbpm/local-em/per-process-instance.xml");
        EntityManager em = (EntityManager)this.context.getBean("jbpmEM");
        List sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertNotNull((Object)sessions);
        Assert.assertEquals((long)0L, (long)sessions.size());
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertNotNull((Object)sessions);
        Assert.assertEquals((long)0L, (long)sessions.size());
    }

    @Test
    public void testRecoveringKieSessionByProcessInstanceIdContext() throws Exception {
        this.context = new ClassPathXmlApplicationContext("jbpm/local-emf/per-process-instance.xml");
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = engine.getKieSession();
        long ksessionId = ksession.getIdentifier();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        System.out.println("Process started");
        manager.disposeRuntimeEngine(engine);
        engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        Assert.assertEquals((long)ksessionId, (long)ksession.getIdentifier());
        AuditLogService logService = (AuditLogService)this.context.getBean("logService");
        ProcessInstanceLog log = logService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)log);
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'john'");
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "john");
        taskService.complete(taskId, "john", null);
        tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'mary'");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "mary");
        taskService.complete(taskId, "mary", null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        System.out.println("Process instance completed");
        manager.disposeRuntimeEngine(engine);
    }
}

