/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.spring.beans.Person;
import org.kie.spring.beans.SampleBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringExpressionTest {
    static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/beans-with-spel.xml");
    }

    @Test
    public void testContext() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testKieBase() throws Exception {
        KieBase kbase = (KieBase)context.getBean("drl_kiesample3");
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testStatelessKieSession() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("ksession1");
        Assert.assertNotNull((Object)ksession);
    }

    @Test
    public void testKieSession() throws Exception {
        KieSession ksession = (KieSession)context.getBean("ksession2");
        Assert.assertNotNull((Object)ksession);
    }

    @Test
    public void testKSessionExecution() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("ksession1");
        Assert.assertNotNull((Object)ksession);
        Person person = new Person("HAL", 42);
        person.setHappy(false);
        ksession.execute((Object)person);
        Assert.assertTrue((boolean)person.isHappy());
    }

    @Test
    public void testKSessionInjection() throws Exception {
        SampleBean sampleBean = (SampleBean)context.getBean("sampleBean");
        Assert.assertNotNull((Object)sampleBean);
        Assert.assertNotNull((Object)sampleBean.getKieSession());
        Assert.assertTrue((boolean)(sampleBean.getKieSession() instanceof StatelessKieSession));
    }

    @AfterClass
    public static void tearDown() {
    }
}

