/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests.annotations;

import java.util.Collection;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.spring.beans.annotations.KContainerBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KContainerInjectionTest {
    static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/annotations/kcontainer-tests.xml");
    }

    @Test
    public void testContext() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testKContainer() throws Exception {
        KContainerBean sampleBean = (KContainerBean)context.getBean("sampleBean");
        Assert.assertNotNull((Object)sampleBean);
        Assert.assertNotNull((Object)sampleBean.getKieContainer());
        Collection kieBaseNames = sampleBean.getKieContainer().getKieBaseNames();
        Assert.assertEquals((String)"Expecting different number of KieBases!", (long)2L, (long)kieBaseNames.size());
        Assert.assertTrue((String)"Expecting KieBase 'drl_kiesample'!", (boolean)kieBaseNames.contains("drl_kiesample"));
        Assert.assertTrue((String)"Expecting KieBase 'drl_kiesample3'!", (boolean)kieBaseNames.contains("drl_kiesample3"));
    }

    @Test
    public void testSetterKContainer() throws Exception {
        KContainerBean sampleBean = (KContainerBean)context.getBean("sampleBean");
        Assert.assertNotNull((Object)sampleBean);
        Assert.assertNotNull((Object)sampleBean.getKieContainer2());
        Collection kieBaseNames = sampleBean.getKieContainer2().getKieBaseNames();
        Assert.assertEquals((String)"Expecting different number of KieBases!", (long)2L, (long)kieBaseNames.size());
        Assert.assertTrue((String)"Expecting KieBase 'drl_kiesample'!", (boolean)kieBaseNames.contains("drl_kiesample"));
        Assert.assertTrue((String)"Expecting KieBase 'drl_kiesample3'!", (boolean)kieBaseNames.contains("drl_kiesample3"));
    }

    @AfterClass
    public static void tearDown() {
    }
}

