/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.tomcat;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.users.AbstractRole;
import org.apache.catalina.users.AbstractUser;
import org.apache.catalina.valves.ValveBase;
import org.kie.integration.tomcat.BasicAuthorizationPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JACCValve
extends ValveBase {
    private static final Logger logger = LoggerFactory.getLogger(JACCValve.class);
    private static ThreadLocal<Request> currentRequest = new ThreadLocal();

    public JACCValve() {
        try {
            PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)new PolicyContextHandler(){

                public boolean supports(String key) throws PolicyContextException {
                    return "javax.security.auth.Subject.container".equals(key);
                }

                public String[] getKeys() throws PolicyContextException {
                    return new String[]{"javax.security.auth.Subject.container"};
                }

                public Object getContext(String key, Object data) throws PolicyContextException {
                    Request req = (Request)currentRequest.get();
                    if (req == null || req.getPrincipal() == null) {
                        return null;
                    }
                    HashSet<Principal> principals = new HashSet<Principal>();
                    principals.add(req.getPrincipal());
                    principals.add((Principal)JACCValve.this.getGroup(req.getPrincipal()));
                    if (req.getPrincipal() instanceof GenericPrincipal) {
                        try {
                            String name = ((GenericPrincipal)req.getPrincipal()).getName();
                            String password = ((GenericPrincipal)req.getPrincipal()).getPassword();
                            String basicAuthHeader = "Basic " + Base64.getEncoder().encodeToString((name + ":" + password).getBytes("UTF-8"));
                            principals.add(new BasicAuthorizationPrincipal(basicAuthHeader));
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.warn("UnsupportedEncodingException while preparing basic auth principal");
                        }
                    }
                    Subject s = new Subject(false, principals, Collections.EMPTY_SET, Collections.EMPTY_SET);
                    return s;
                }
            }, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        currentRequest.set(request);
        this.wrapListeners(request);
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            currentRequest.set(null);
        }
    }

    protected Group getGroup(Principal principal) {
        Group group;
        block3: {
            String[] roles;
            block2: {
                group = new Group(){
                    private List<Principal> members = new ArrayList<Principal>();

                    public String getName() {
                        return "Roles";
                    }

                    public boolean removeMember(Principal user) {
                        return this.members.remove(user);
                    }

                    public Enumeration<? extends Principal> members() {
                        return Collections.enumeration(this.members);
                    }

                    public boolean isMember(Principal member) {
                        return this.members.contains(member);
                    }

                    public boolean addMember(Principal user) {
                        return this.members.add(user);
                    }
                };
                if (!(principal instanceof AbstractUser)) break block2;
                Iterator it = ((AbstractUser)principal).getRoles();
                while (it.hasNext()) {
                    AbstractRole user = (AbstractRole)it.next();
                    group.addMember((Principal)user);
                }
                break block3;
            }
            if (!(principal instanceof GenericPrincipal)) break block3;
            for (final String role : roles = ((GenericPrincipal)principal).getRoles()) {
                group.addMember(new Principal(){

                    @Override
                    public String getName() {
                        return role;
                    }
                });
            }
        }
        return group;
    }

    protected void wrapListeners(Request request) {
        Context context = request.getContext();
        Object[] listeners = context.getApplicationEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletRequestListener) || listeners[i] instanceof WrappedServletRequestListener) continue;
            listeners[i] = new WrappedServletRequestListener((ServletRequestListener)listeners[i]);
        }
    }

    private static class WrappedServletRequestListener
    implements ServletRequestListener {
        private ServletRequestListener delegate;

        WrappedServletRequestListener(ServletRequestListener delegate) {
            this.delegate = delegate;
        }

        public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
            try {
                this.delegate.requestDestroyed(servletRequestEvent);
            }
            catch (Exception e) {
                logger.debug("Exception at request destroy {}", (Object)e.getMessage(), (Object)e);
            }
        }

        public void requestInitialized(ServletRequestEvent servletRequestEvent) {
            try {
                this.delegate.requestInitialized(servletRequestEvent);
            }
            catch (Exception e) {
                logger.debug("Exception at request initialization {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

